/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FileBasedIndexExtension<K, V> {
    public static final ExtensionPointName<FileBasedIndexExtension> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.fileBasedIndex");
    public static final int DEFAULT_CACHE_SIZE = 1024;

    public abstract ID<K, V> getName();

    public abstract DataIndexer<K, V, FileContent> getIndexer();

    public abstract KeyDescriptor<K> getKeyDescriptor();

    public abstract DataExternalizer<V> getValueExternalizer();

    public abstract FileBasedIndex.InputFilter getInputFilter();

    public abstract boolean dependsOnFileContent();

    public abstract int getVersion();

    public int getCacheSize() {
        return 1024;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        List<FileType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileBasedIndexExtension.getFileTypesWithSizeLimitNotApplicable must not return null");
        }
        return list;
    }
}

