/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class MethodInheritanceUtils {
    private MethodInheritanceUtils() {
    }

    public static Set<PsiMethod> calculateSiblingMethods(PsiMethod method) {
        HashSet<PsiMethod> siblingMethods = new HashSet<PsiMethod>();
        Stack<PsiMethod> pendingMethods = new Stack<PsiMethod>();
        pendingMethods.add(method);
        while (!pendingMethods.isEmpty()) {
            PsiMethod[] superMethods;
            PsiMethod methodToAnalyze = (PsiMethod)pendingMethods.pop();
            siblingMethods.add(methodToAnalyze);
            Query overridingMethods = OverridingMethodsSearch.search((PsiMethod)methodToAnalyze, (SearchScope)methodToAnalyze.getUseScope(), (boolean)false);
            for (PsiMethod overridingMethod : overridingMethods) {
                if (siblingMethods.contains(overridingMethod) || pendingMethods.contains(overridingMethod)) continue;
                pendingMethods.add(overridingMethod);
            }
            for (PsiMethod superMethod : superMethods = methodToAnalyze.findSuperMethods()) {
                if (siblingMethods.contains(superMethod) || pendingMethods.contains(superMethod)) continue;
                pendingMethods.add(superMethod);
            }
        }
        return siblingMethods;
    }

    public static boolean hasSiblingMethods(PsiMethod method) {
        Iterable<PsiMethod> overridingMethods = SearchUtils.findOverridingMethods(method);
        if (overridingMethods.iterator().hasNext()) {
            return true;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        return superMethods.length != 0;
    }

    public static PsiClass[] findAvailableSuperClassesForMethod(PsiMethod method) {
        ArrayList<PsiClass> sourceClasses = new ArrayList<PsiClass>();
        MethodInheritanceUtils.findAvailableSuperClasses(method, sourceClasses);
        return sourceClasses.toArray(new PsiClass[sourceClasses.size()]);
    }

    private static void findAvailableSuperClasses(PsiMethod method, List<PsiClass> sourceClasses) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method.findSuperMethods(true)) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass instanceof PsiCompiledElement) continue;
            sourceClasses.add(containingClass);
            MethodInheritanceUtils.findAvailableSuperClasses(superMethod, sourceClasses);
        }
    }

    public static PsiClass[] findAvailableSubClassesForMethod(PsiMethod method) {
        Iterable<PsiMethod> query = SearchUtils.findOverridingMethods(method);
        ArrayList<PsiClass> sourceClasses = new ArrayList<PsiClass>();
        for (PsiMethod superMethod : query) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass instanceof PsiCompiledElement) continue;
            sourceClasses.add(containingClass);
        }
        return sourceClasses.toArray(new PsiClass[sourceClasses.size()]);
    }

    public static PsiClass[] getNonLibrarySuperClasses(PsiClass sourceClass) {
        ArrayList<PsiClass> out = new ArrayList<PsiClass>();
        MethodInheritanceUtils.findNonLibrarySupers(sourceClass, out);
        return out.toArray(new PsiClass[out.size()]);
    }

    private static void findNonLibrarySupers(PsiClass sourceClass, List<PsiClass> out) {
        PsiClass[] supers;
        for (PsiClass psiClass : supers = sourceClass.getSupers()) {
            if (psiClass instanceof PsiCompiledElement || out.contains(psiClass)) continue;
            out.add(psiClass);
            MethodInheritanceUtils.findNonLibrarySupers(psiClass, out);
        }
    }

    public static PsiClass[] getNonLibrarySubClasses(PsiClass sourceClass) {
        ArrayList<PsiClass> out = new ArrayList<PsiClass>();
        Iterable<PsiClass> query = SearchUtils.findClassInheritors(sourceClass, true);
        for (PsiClass psiClass : query) {
            if (psiClass instanceof PsiCompiledElement) continue;
            out.add(psiClass);
        }
        return out.toArray(new PsiClass[out.size()]);
    }
}

