/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.intellij.refactoring.memberPushDown.JavaPushDownHandler;
import com.intellij.refactoring.memberPushDown.PushDownProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PushDownDialog
extends RefactoringDialog {
    private final List<MemberInfo> myMemberInfos;
    private final PsiClass myClass;
    private DocCommentPanel myJavaDocPanel;
    private MemberInfoModel<PsiMember, MemberInfo> myMemberInfoModel;

    public PushDownDialog(Project project, MemberInfo[] memberInfos, PsiClass aClass) {
        super(project, true);
        this.myMemberInfos = Arrays.asList(memberInfos);
        this.myClass = aClass;
        this.setTitle(JavaPushDownHandler.REFACTORING_NAME);
        this.init();
    }

    public int getJavaDocPolicy() {
        return this.myJavaDocPanel.getPolicy();
    }

    public MemberInfo[] getSelectedMemberInfos() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>(this.myMemberInfos.size());
        for (MemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add(info);
        }
        return list.toArray(new MemberInfo[list.size()]);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.pushMembersDown");
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.memberPushDown.PushDownDialog";
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"push.members.from.0.down.label", (Object[])new Object[]{this.myClass.getQualifiedName()})), gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pushed.down.panel.title"), this.myMemberInfos, RefactoringBundle.message((String)"keep.abstract.column.header"));
        panel.add((Component)memberSelectionPanel, "Center");
        this.myMemberInfoModel = new MyMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener(this.myMemberInfoModel);
        this.myJavaDocPanel = new DocCommentPanel(RefactoringBundle.message((String)"push.down.javadoc.panel.title"));
        this.myJavaDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        panel.add((Component)this.myJavaDocPanel, "East");
        return panel;
    }

    @Override
    protected void doAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        JavaRefactoringSettings.getInstance().PUSH_DOWN_PREVIEW_USAGES = this.isPreviewUsages();
        this.invokeRefactoring(new PushDownProcessor(this.getProject(), this.getSelectedMemberInfos(), this.myClass, new DocCommentPolicy(this.getJavaDocPolicy())));
    }

    private class MyMemberInfoModel
    extends UsedByDependencyMemberInfoModel<PsiMember, PsiClass, MemberInfo> {
        public MyMemberInfoModel() {
            super(PushDownDialog.this.myClass);
        }
    }
}

