/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.XmlAttributeLiteralEscaper;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValueImpl
extends XmlElementImpl
implements XmlAttributeValue,
PsiLanguageInjectionHost,
PsiMetaOwner,
PsiMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeValueImpl");
    private volatile PsiReference[] myCachedReferences;
    private volatile long myModCount;

    public XmlAttributeValueImpl() {
        super(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlAttributeValueImpl.accept must not be null");
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttributeValue((XmlAttributeValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        return StringUtil.stripQuotesAroundValue((String)this.getText());
    }

    public TextRange getValueTextRange() {
        TextRange range = this.getTextRange();
        String value = this.getValue();
        if (value.length() == 0) {
            return range;
        }
        int start = range.getStartOffset() + this.getText().indexOf(value);
        int end = start + value.length();
        return new TextRange(start, end);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedReferences = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        PsiReference[] cachedReferences = this.myCachedReferences;
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        if (cachedReferences != null && this.myModCount == curModCount) {
            psiReferenceArray = cachedReferences;
            if (cachedReferences == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeValueImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        this.myCachedReferences = cachedReferences = ReferenceProvidersRegistry.getReferencesFromProviders(this, XmlAttributeValue.class);
        this.myModCount = curModCount;
        psiReferenceArray = cachedReferences;
        if (cachedReferences != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeValueImpl.getReferences must not return null");
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    @Nullable
    public List<Pair<PsiElement, TextRange>> getInjectedPsi() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlAttributeImpl) {
            return InjectedLanguageUtil.getInjectedPsiFiles(this);
        }
        return null;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlAttributeValueImpl.updateText must not be null");
        }
        try {
            String contents = StringUtil.trimEnd((String)StringUtil.trimStart((String)text, (String)"\""), (String)"\"");
            XmlAttribute newAttribute = XmlElementFactory.getInstance((Project)this.getProject()).createXmlAttribute("q", contents);
            XmlAttributeValue newValue = newAttribute.getValueElement();
            CheckUtil.checkWritable(this);
            this.replaceAllChildrenToChildrenOf(newValue.getNode());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    @NotNull
    public LiteralTextEscaper<XmlAttributeValueImpl> createLiteralTextEscaper() {
        XmlAttributeLiteralEscaper xmlAttributeLiteralEscaper = new XmlAttributeLiteralEscaper(this);
        if (xmlAttributeLiteralEscaper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeValueImpl.createLiteralTextEscaper must not return null");
        }
        return xmlAttributeLiteralEscaper;
    }

    public void processInjectedPsi(@NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlAttributeValueImpl.processInjectedPsi must not be null");
        }
        InjectedLanguageUtil.enumerate(this, visitor);
    }

    public PsiMetaData getMetaData() {
        return this;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getValue();
    }

    @Override
    public String getName() {
        return this.getValue();
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

