/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.parsing.ExpressionParsing;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedSoftReference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiField,
PsiVariableEx,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiFieldImpl");
    private volatile PatchedSoftReference<PsiType> myCachedType = null;
    private volatile Object myCachedInitializerValue = null;

    public PsiFieldImpl(PsiFieldStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.FIELD);
    }

    protected PsiFieldImpl(PsiFieldStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiFieldImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    private void dropCached() {
        this.myCachedInitializerValue = null;
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiFieldImpl clone = (PsiFieldImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, JspClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getNode must not return null");
        }
        return compositeElement;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string;
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            string = stub.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getName must not return null");
            return string;
        }
        string = this.getNameIdentifier().getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getName must not return null");
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    public PsiType getTypeNoResolve() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            String typeText = TypeInfo.createTypeText(stub.getType(false));
            try {
                PsiType type = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
                this.myCachedType = new PatchedSoftReference<PsiType>(type);
                return type;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        PsiTypeElement typeElement = this.getTypeElement();
        PsiIdentifier nameIdentifier = this.getNameIdentifier();
        return JavaSharedImplUtil.getTypeNoResolve(typeElement, (PsiElement)nameIdentifier, (PsiElement)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiType getType() {
        PsiType psiType;
        PsiType type;
        PsiType psiType2;
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub == null) {
            this.myCachedType = null;
            PsiType psiType3 = JavaSharedImplUtil.getType(this);
            psiType2 = psiType3;
            if (psiType3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
            return psiType2;
        }
        PatchedSoftReference<PsiType> cachedType = this.myCachedType;
        if (cachedType != null && (type = (PsiType)cachedType.get()) != null) {
            PsiType psiType4 = type;
            psiType2 = psiType4;
            if (psiType4 != null) return psiType2;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
        }
        String typeText = TypeInfo.createTypeText(stub.getType(true));
        try {
            PsiType type2 = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
            this.myCachedType = new PatchedSoftReference<PsiType>(type2);
            psiType = type2;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            psiType2 = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
        }
        psiType2 = psiType;
        if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
        return psiType2;
    }

    public PsiTypeElement getTypeElement() {
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField != this) {
            return firstField.getTypeElement();
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList;
        PsiModifierList selfModifierList = this.getSelfModifierList();
        if (selfModifierList != null) {
            psiModifierList = selfModifierList;
            if (psiModifierList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getModifierList must not return null");
            return psiModifierList;
        }
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField == this) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)this);
            }
            PsiField lastResort = this.findFirstFieldByTree();
            if (lastResort == this) {
                throw new IllegalStateException("Missing modifier list for sequence of fields: '" + this.getText() + "'");
            }
            firstField = lastResort;
        }
        if ((psiModifierList = firstField.getModifierList()) != null) return psiModifierList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getModifierList must not return null");
    }

    @Nullable
    private PsiModifierList getSelfModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    private PsiField findFirstFieldInDeclaration() {
        if (this.getSelfModifierList() != null) {
            return this;
        }
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            List siblings = stub.getParentStub().getChildrenStubs();
            int idx = siblings.indexOf(stub);
            assert (idx >= 0);
            for (int i = idx - 1; i >= 0 && siblings.get(i) instanceof PsiFieldStub; --i) {
                PsiFieldStub prevField = (PsiFieldStub)siblings.get(i);
                PsiFieldImpl prevFieldPsi = (PsiFieldImpl)prevField.getPsi();
                if (prevFieldPsi.getSelfModifierList() == null) continue;
                return prevFieldPsi;
            }
        }
        return this.findFirstFieldByTree();
    }

    private PsiField findFirstFieldByTree() {
        CompositeElement treeElement = this.getNode();
        ASTNode modifierList = treeElement.findChildByRole(8);
        if (modifierList == null) {
            TreeElement prevField;
            for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
            }
            if (prevField == null) {
                return this;
            }
            return ((PsiFieldImpl)SourceTreeToPsiMap.treeElementToPsi(prevField)).findFirstFieldInDeclaration();
        }
        return this;
    }

    public PsiExpression getInitializer() {
        return (PsiExpression)this.getNode().findChildByRoleAsPsiElement(21);
    }

    public boolean hasInitializer() {
        if (this.getStub() != null) {
            return this.getInitializerText() != null;
        }
        return this.getInitializer() != null;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiFieldImpl.createLayeredIcon((Icon)Icons.FIELD_ICON, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Nullable
    private Object _computeConstantValue(Set<PsiVariable> visitedVars) {
        PsiExpression initializer;
        Object cachedInitializerValue = this.myCachedInitializerValue;
        if (cachedInitializerValue != null && !(cachedInitializerValue instanceof PsiExpression)) {
            return cachedInitializerValue;
        }
        PsiType type = this.getType();
        if (!(type instanceof PsiPrimitiveType) && !type.equalsToText("java.lang.String")) {
            return null;
        }
        if (cachedInitializerValue != null) {
            initializer = (PsiExpression)cachedInitializerValue;
        } else {
            PsiFieldStub stub = (PsiFieldStub)this.getStub();
            if (stub == null) {
                initializer = this.getInitializer();
                if (initializer == null) {
                    return null;
                }
            } else {
                String initializerText = this.getInitializerText();
                if (initializerText == null) {
                    return null;
                }
                if (";INITIALIZER_NOT_STORED;".equals(initializerText)) {
                    return null;
                }
                if (";INITIALIZER_TOO_LONG;".equals(initializerText)) {
                    this.getNode();
                    return this.computeConstantValue(visitedVars);
                }
                PsiManagerEx manager = this.getManager();
                FileElement holderElement = DummyHolderFactory.createHolder(manager, (PsiElement)this).getTreeElement();
                CompositeElement expressionElement = ExpressionParsing.parseExpressionText(manager, initializerText, 0, initializerText.length(), holderElement.getCharTable());
                holderElement.rawAddChildren(expressionElement);
                initializer = (PsiExpression)SourceTreeToPsiMap.treeElementToPsi(expressionElement);
            }
        }
        Object result = PsiConstantEvaluationHelperImpl.computeCastTo(initializer, type, visitedVars);
        this.myCachedInitializerValue = initializer instanceof PsiLiteralExpression ? result : initializer;
        return result;
    }

    public Object computeConstantValue() {
        Object cachedInitializerValue = this.myCachedInitializerValue;
        if (cachedInitializerValue != null && !(cachedInitializerValue instanceof PsiExpression)) {
            return cachedInitializerValue;
        }
        return this.computeConstantValue(new HashSet<PsiVariable>(2));
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        return JavaResolveCache.getInstance(this.getProject()).computeConstantValueWithCaching(this, OurConstValueComputer.INSTANCE, visitedVars);
    }

    @Nullable
    private String getInitializerText() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.getInitializerText();
        }
        throw new RuntimeException("Shall not be called when in stubless mode");
    }

    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiDocComment getDocComment() {
        CompositeElement treeElement = this.getNode();
        if (this.getTypeElement() != null) {
            return (PsiDocComment)treeElement.findChildByRoleAsPsiElement(7);
        }
        TreeElement prevField = treeElement.getTreePrev();
        while (prevField.getElementType() != JavaElementType.FIELD) {
            prevField = prevField.getTreePrev();
        }
        return ((PsiField)SourceTreeToPsiMap.treeElementToPsi(prevField)).getDocComment();
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        ASTNode nextField;
        ASTNode comma;
        CheckUtil.checkWritable((PsiElement)this);
        PsiTypeElement type = this.getTypeElement();
        PsiModifierList modifierList = this.getModifierList();
        ASTNode field = SourceTreeToPsiMap.psiElementToTree(type.getParent());
        while ((comma = TreeUtil.skipElements(field.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = TreeUtil.skipElements(comma.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && nextField.getElementType() == JavaElementType.FIELD) {
            LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, null, this.getManager());
            CodeEditUtil.addChild((CompositeElement)field, semicolon, null);
            CodeEditUtil.removeChild((CompositeElement)comma.getTreeParent(), comma);
            PsiElement typeClone = type.copy();
            CodeEditUtil.addChild((CompositeElement)nextField, SourceTreeToPsiMap.psiElementToTree(typeClone), nextField.getFirstChildNode());
            PsiElement modifierListClone = modifierList.copy();
            CodeEditUtil.addChild((CompositeElement)nextField, SourceTreeToPsiMap.psiElementToTree(modifierListClone), nextField.getFirstChildNode());
            field = nextField;
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField((PsiField)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiClass originalClass = (PsiClass)this.getContainingClass().getOriginalElement();
        PsiField originalField = originalClass.findFieldByName(this.getName(), false);
        return originalField != null ? originalField : this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getFieldPresentation(this);
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public void putInfo(Map<String, String> info) {
        info.put("fieldName", this.getName());
    }

    private static class OurConstValueComputer
    implements JavaResolveCache.ConstValueComputer {
        private static final OurConstValueComputer INSTANCE = new OurConstValueComputer();

        private OurConstValueComputer() {
        }

        @Override
        public Object execute(PsiVariable variable, Set<PsiVariable> visitedVars) {
            return ((PsiFieldImpl)variable)._computeConstantValue(visitedVars);
        }
    }
}

