/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.util.diff.Diff;
import org.jetbrains.annotations.NonNls;

public class Range {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.Range");
    public static final byte MODIFIED = 1;
    public static final byte INSERTED = 2;
    public static final byte DELETED = 3;
    private int myOffset1;
    private int myOffset2;
    private final int myUpToDateOffset1;
    private final int myUpToDateOffset2;
    private final byte myType;
    private RangeHighlighter myRangeHighlighter;

    public static Range createOn(Diff.Change change, int shift, int upToDateShift) {
        byte type = Range.getChangeTypeFrom(change);
        int offset1 = shift + change.line1;
        int offset2 = offset1 + change.inserted;
        int uOffset1 = upToDateShift + change.line0;
        int uOffset2 = uOffset1 + change.deleted;
        return new Range(offset1, offset2, uOffset1, uOffset2, type);
    }

    private static byte getChangeTypeFrom(Diff.Change change) {
        if (change.deleted > 0 && change.inserted > 0) {
            return 1;
        }
        if (change.deleted > 0) {
            return 3;
        }
        if (change.inserted > 0) {
            return 2;
        }
        LOG.error("Unknown change type");
        return 0;
    }

    public Range(int offset1, int offset2, int uOffset1, int uOffset2, byte type) {
        this.myOffset1 = offset1;
        this.myOffset2 = offset2;
        this.myUpToDateOffset1 = uOffset1;
        this.myUpToDateOffset2 = uOffset2;
        this.myType = type;
    }

    public int hashCode() {
        return this.myUpToDateOffset1 ^ this.myUpToDateOffset2 ^ this.myType ^ this.myOffset1 ^ this.myOffset2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range other = (Range)object;
        return this.myOffset1 == other.myOffset1 && this.myUpToDateOffset1 == other.myUpToDateOffset1 && this.myUpToDateOffset2 == other.myUpToDateOffset2 && this.myOffset1 == other.myOffset1 && this.myOffset2 == other.myOffset2 && this.myType == other.myType;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.valueOf(this.myOffset1));
        result.append(", ");
        result.append(String.valueOf(this.myOffset2));
        result.append(", ");
        result.append(String.valueOf(this.myUpToDateOffset1));
        result.append(", ");
        result.append(String.valueOf(this.myUpToDateOffset2));
        result.append(", ");
        result.append(this.getTypeName());
        return result.toString();
    }

    @NonNls
    private String getTypeName() {
        switch (this.myType) {
            case 1: {
                return "MODIFIED";
            }
            case 2: {
                return "INSERTED";
            }
            case 3: {
                return "DELETED";
            }
        }
        return "UNKNOWN";
    }

    public byte getType() {
        return this.myType;
    }

    public int getUpToDateRangeLength() {
        return this.myUpToDateOffset2 - this.myUpToDateOffset1;
    }

    public boolean isInRange(int from, int to) {
        return this.myOffset2 >= from && this.myOffset1 <= from || this.myOffset1 <= to && this.myOffset2 >= to;
    }

    public void shift(int shift) {
        this.myOffset1 += shift;
        this.myOffset2 += shift;
    }

    public boolean isAfter(int to) {
        return this.myOffset1 > to;
    }

    public int getCurrentLength() {
        return this.myOffset2 - this.myOffset1;
    }

    public int getOffset1() {
        return this.myOffset1;
    }

    public int getOffset2() {
        return this.myOffset2;
    }

    public int getUOffset1() {
        return this.myUpToDateOffset1;
    }

    public int getUOffset2() {
        return this.myUpToDateOffset2;
    }

    public boolean canBeMergedWith(Range range) {
        return this.myOffset2 == range.myOffset1;
    }

    public Range mergeWith(Range range, LineStatusTracker tracker) {
        tracker.removeHighlighter(this.getHighlighter());
        this.setHighlighter(null);
        tracker.removeHighlighter(range.getHighlighter());
        range.setHighlighter(null);
        Range result = new Range(this.myOffset1, range.myOffset2, this.myUpToDateOffset1, range.myUpToDateOffset2, this.mergedStatusWith(range));
        return result;
    }

    private byte mergedStatusWith(Range range) {
        byte type = this.myType;
        if (this.myType != range.myType) {
            type = 1;
        }
        return type;
    }

    public boolean hasHighlighter() {
        return this.myRangeHighlighter != null;
    }

    public void setHighlighter(RangeHighlighter highlighter) {
        this.myRangeHighlighter = highlighter;
    }

    public RangeHighlighter getHighlighter() {
        return this.myRangeHighlighter;
    }

    public boolean contains(int offset1, int offset2) {
        return this.getOffset1() <= offset1 && this.getOffset2() >= offset2;
    }

    public boolean containsLine(int line) {
        if (this.myType == 3) {
            return this.myOffset1 - 1 <= line && this.myOffset2 >= line;
        }
        return this.myOffset1 <= line && this.myOffset2 >= line;
    }

    public boolean isMoreThen(int line) {
        if (this.myType == 3) {
            return this.getOffset1() - 1 > line;
        }
        return this.getOffset1() > line;
    }
}

