/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;

public class SelectFilesDialog
extends AbstractSelectFilesDialog<VirtualFile> {
    public SelectFilesDialog(final Project project, List<VirtualFile> originalFiles, String prompt, VcsShowConfirmationOption confirmationOption) {
        super(project, false, confirmationOption, prompt);
        this.myFileList = new ChangesTreeList<VirtualFile>(project, originalFiles, true, true, null, null){

            @Override
            protected DefaultTreeModel buildTreeModel(List<VirtualFile> changes, ChangeNodeDecorator changeNodeDecorator) {
                return new TreeModelBuilder(project, false).buildModelFromFiles(changes);
            }

            @Override
            protected List<VirtualFile> getSelectedObjects(ChangesBrowserNode node) {
                return node.getAllFilesUnder();
            }

            @Override
            protected VirtualFile getLeadSelectedObject(ChangesBrowserNode node) {
                Object o = node.getUserObject();
                if (o instanceof VirtualFile) {
                    return (VirtualFile)o;
                }
                return null;
            }
        };
        this.myFileList.setChangesToDisplay(originalFiles);
        this.myPanel.add((Component)this.myFileList, "Center");
        this.init();
    }

    public Collection<VirtualFile> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }
}

