/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements NamedJDOMExternalizable,
ExportableApplicationComponent {
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS = false;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectManagerImpl");
    public static final int CURRENT_FORMAT_VERSION = 4;
    private static final Key<ArrayList<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    @NonNls
    private static final String ELEMENT_DEFAULT_PROJECT = "defaultProject";
    private ProjectImpl myDefaultProject;
    private Element myDefaultProjectRootElement;
    private final ArrayList<Project> myOpenProjects = new ArrayList();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createEmptyCOWList();
    private Project myCurrentTestProject = null;
    private final Map<VirtualFile, byte[]> mySavedCopies = new HashMap();
    private final TObjectLongHashMap<VirtualFile> mySavedTimestamps = new TObjectLongHashMap();
    private final Map<Project, List<Pair<VirtualFile, StateStorage>>> myChangedProjectFiles = new HashMap();
    private final Alarm myChangedFilesAlarm = new Alarm();
    private final List<Pair<VirtualFile, StateStorage>> myChangedApplicationFiles = new ArrayList<Pair<VirtualFile, StateStorage>>();
    private final AtomicInteger myReloadBlockCount = new AtomicInteger(0);
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();
    private static final int MAX_LEAKY_PROJECTS = 42;

    private static ProjectManagerListener[] getListeners(Project project) {
        ArrayList array = (ArrayList)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            return ProjectManagerListener.EMPTY_ARRAY;
        }
        return (ProjectManagerListener[])ContainerUtil.toArray((List)array, (Object[])new ProjectManagerListener[array.size()]);
    }

    public ProjectManagerImpl(VirtualFileManagerEx virtualFileManagerEx) {
        Application app = ApplicationManager.getApplication();
        MessageBus messageBus = app.getMessageBus();
        MessageBusConnection connection = messageBus.connect((Disposable)app);
        connection.subscribe(StateStorage.STORAGE_TOPIC, (Object)new StateStorage.Listener(){

            public void storageFileChanged(VirtualFileEvent event, @NotNull StateStorage storage) {
                if (storage == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/project/impl/ProjectManagerImpl$1.storageFileChanged must not be null");
                }
                VirtualFile file = event.getFile();
                if (!file.isDirectory() && !(event.getRequestor() instanceof StateStorage.SaveSession)) {
                    ProjectManagerImpl.this.saveChangedProjectFile(file, null, storage);
                }
            }
        });
        this.addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(final Project project) {
                ProjectManagerListener[] listeners;
                MessageBus messageBus = project.getMessageBus();
                MessageBusConnection connection = messageBus.connect((Disposable)project);
                connection.subscribe(StateStorage.STORAGE_TOPIC, (Object)new StateStorage.Listener(){

                    public void storageFileChanged(VirtualFileEvent event, @NotNull StateStorage storage) {
                        if (storage == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/project/impl/ProjectManagerImpl$2$1.storageFileChanged must not be null");
                        }
                        VirtualFile file = event.getFile();
                        if (!file.isDirectory() && !(event.getRequestor() instanceof StateStorage.SaveSession)) {
                            ProjectManagerImpl.this.saveChangedProjectFile(file, project, storage);
                        }
                    }
                });
                for (ProjectManagerListener listener : listeners = ProjectManagerImpl.getListeners(project)) {
                    listener.projectOpened(project);
                }
            }

            public void projectClosed(Project project) {
                ProjectManagerListener[] listeners;
                for (ProjectManagerListener listener : listeners = ProjectManagerImpl.getListeners(project)) {
                    listener.projectClosed(project);
                }
            }

            public boolean canCloseProject(Project project) {
                ProjectManagerListener[] listeners;
                for (ProjectManagerListener listener : listeners = ProjectManagerImpl.getListeners(project)) {
                    if (listener.canCloseProject(project)) continue;
                    return false;
                }
                return true;
            }

            public void projectClosing(Project project) {
                ProjectManagerListener[] listeners;
                for (ProjectManagerListener listener : listeners = ProjectManagerImpl.getListeners(project)) {
                    listener.projectClosing(project);
                }
            }
        });
        this.registerExternalProjectFileListener(virtualFileManagerEx);
    }

    public void disposeComponent() {
        Disposer.dispose((Disposable)this.myChangedFilesAlarm);
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
        }
    }

    public void initComponent() {
    }

    @Override
    @Nullable
    public Project newProject(String projectName, String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        filePath = ProjectManagerImpl.canonicalize(filePath);
        try {
            ProjectImpl project = this.createAndInitProject(projectName, filePath, false, isDummy, ApplicationManager.getApplication().isUnitTestMode(), useDefaultProjectSettings ? this.getDefaultProject() : null);
            return project;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(e), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    private static String message(Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            return message;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            return message + " (cause: " + causeMessage + ")";
        }
        return message;
    }

    private ProjectImpl createAndInitProject(String projectName, String filePath, boolean isDefault, boolean isDummy, boolean isOptimiseTestLoadSpeed, @Nullable Project template) throws IOException {
        if (isDummy) {
            throw new UnsupportedOperationException("Dummy project is deprecated and shall not be used anymore.");
        }
        ProjectImpl project = isDefault ? new DefaultProject(this, filePath, isOptimiseTestLoadSpeed, projectName) : new ProjectImpl(this, filePath, isOptimiseTestLoadSpeed, projectName);
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded(project);
        try {
            if (template != null) {
                project.getStateStore().loadProjectFromTemplate((ProjectImpl)template);
            } else {
                project.getStateStore().load();
            }
        }
        catch (IOException e) {
            ProjectManagerImpl.scheduleDispose(project);
            throw e;
        }
        catch (StateStorage.StateStorageException e) {
            ProjectManagerImpl.scheduleDispose(project);
            throw e;
        }
        project.loadProjectComponents();
        project.init();
        return project;
    }

    private static void scheduleDispose(final ProjectImpl project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Disposer.dispose((Disposable)project);
            }
        });
    }

    @Override
    @Nullable
    public Project loadProject(String filePath) throws IOException, JDOMException, InvalidDataException {
        try {
            return this.doLoadProject(filePath);
        }
        catch (StateStorage.StateStorageException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Nullable
    private Project doLoadProject(String filePath) throws IOException, StateStorage.StateStorageException {
        filePath = ProjectManagerImpl.canonicalize(filePath);
        ProjectImpl project = null;
        try {
            project = this.createAndInitProject(null, filePath, false, false, false, null);
        }
        catch (ProcessCanceledException e) {
            if (project != null) {
                ProjectManagerImpl.scheduleDispose(project);
            }
            throw e;
        }
        return project;
    }

    @Nullable
    protected static String canonicalize(String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            return FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            return filePath;
        }
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        if (this.myDefaultProject == null) {
            try {
                this.myDefaultProject = this.createAndInitProject(null, null, true, false, ApplicationManager.getApplication().isUnitTestMode(), null);
                this.myDefaultProjectRootElement = null;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (StateStorage.StateStorageException e) {
                LOG.error((Throwable)e);
            }
        }
        ProjectImpl projectImpl = this.myDefaultProject;
        if (projectImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectManagerImpl.getDefaultProject must not return null");
        }
        return projectImpl;
    }

    public Element getDefaultProjectRootElement() {
        return this.myDefaultProjectRootElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Project[] getOpenProjects() {
        Project[] projectArray;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Project currentTestProject = this.myCurrentTestProject;
            if (this.myOpenProjects.isEmpty() && currentTestProject != null && !currentTestProject.isDisposed()) {
                projectArray = new Project[]{currentTestProject};
                if (projectArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectManagerImpl.getOpenProjects must not return null");
                return projectArray;
            }
        }
        if ((projectArray = (Project[])ContainerUtil.toArray(this.myOpenProjects, (Object[])new Project[this.myOpenProjects.size()])) != null) return projectArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectManagerImpl.getOpenProjects must not return null");
    }

    @Override
    public boolean isProjectOpened(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myOpenProjects.isEmpty() && this.myCurrentTestProject != null) {
            return project == this.myCurrentTestProject;
        }
        return this.myOpenProjects.contains(project);
    }

    @Override
    public boolean openProject(final Project project) {
        if (this.myOpenProjects.contains(project)) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !((ProjectEx)project).getStateStore().checkVersion()) {
            return false;
        }
        this.myOpenProjects.add(project);
        this.fireProjectOpened(project);
        final StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project);
        boolean ok = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                startupManager.runStartupActivities();
            }
        }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true, project);
        if (!ok) {
            this.closeProject(project, false);
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        startupManager.runPostStartupActivities();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    TrackingPathMacroSubstitutor macroSubstitutor = ((ProjectEx)project).getStateStore().getStateStorageManager().getMacroSubstitutor();
                    if (macroSubstitutor != null) {
                        StorageUtil.notifyUnknownMacros(macroSubstitutor, project, null);
                    }
                }
            });
        }
        return true;
    }

    public Project loadAndOpenProject(String filePath) throws IOException, JDOMException, InvalidDataException {
        return this.loadAndOpenProject(filePath, true);
    }

    @Nullable
    protected Project convertAndLoadProject(String filePath, boolean convert) throws IOException {
        return this.loadProjectWithProgress(filePath);
    }

    @Override
    @Nullable
    public Project loadAndOpenProject(String filePath, boolean convert) throws IOException, JDOMException, InvalidDataException {
        try {
            Project project = this.convertAndLoadProject(filePath, convert);
            if (project == null) {
                return null;
            }
            if (!this.openProject(project)) {
                Disposer.dispose((Disposable)project);
                return null;
            }
            return project;
        }
        catch (StateStorage.StateStorageException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Nullable
    public Project loadProjectWithProgress(String filePath) throws IOException {
        return this.loadProjectWithProgress(filePath, null);
    }

    @Nullable
    public Project loadProjectWithProgress(final String filePath, Ref<Boolean> canceled) throws IOException {
        final IOException[] io = new IOException[]{null};
        final StateStorage.StateStorageException[] stateStorage = new StateStorage.StateStorageException[]{null};
        if (filePath != null) {
            ProjectManagerImpl.refreshProjectFiles(filePath);
        }
        final Project[] project = new Project[1];
        boolean ok = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (indicator != null) {
                        indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{filePath}));
                        indicator.setIndeterminate(true);
                    }
                    project[0] = ProjectManagerImpl.this.doLoadProject(filePath);
                }
                catch (IOException e) {
                    io[0] = e;
                    return;
                }
                catch (StateStorage.StateStorageException e) {
                    stateStorage[0] = e;
                    return;
                }
                if (indicator != null) {
                    indicator.setText(ProjectBundle.message((String)"initializing.components", (Object[])new Object[0]));
                }
            }
        }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), true, null);
        if (!ok) {
            if (project[0] != null) {
                Disposer.dispose((Disposable)project[0]);
                project[0] = null;
            }
            if (canceled != null) {
                canceled.set((Object)true);
            }
            ProjectManagerImpl.notifyProjectOpenFailed();
        }
        if (io[0] != null) {
            throw io[0];
        }
        if (stateStorage[0] != null) {
            throw stateStorage[0];
        }
        if (project[0] == null || !ok) {
            return null;
        }
        return project[0];
    }

    private static void refreshProjectFiles(String filePath) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isDispatchThread()) {
            File file = new File(filePath);
            if (file.isFile()) {
                VirtualFile projectFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
                if (projectFile != null) {
                    projectFile.refresh(false, false);
                }
                File iwsFile = new File(file.getParentFile(), FileUtil.getNameWithoutExtension((File)file) + ".iws");
                VirtualFile wsFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(iwsFile);
                if (wsFile != null) {
                    wsFile.refresh(false, false);
                }
            } else {
                VirtualFile projectConfigDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(filePath, ".idea"));
                if (projectConfigDir != null && projectConfigDir.isDirectory()) {
                    projectConfigDir.getChildren();
                    if (projectConfigDir instanceof NewVirtualFile) {
                        ((NewVirtualFile)projectConfigDir).markDirtyRecursively();
                    }
                    projectConfigDir.refresh(false, true);
                }
            }
        }
    }

    private static void notifyProjectOpenFailed() {
        ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
    }

    private void registerExternalProjectFileListener(VirtualFileManagerEx virtualFileManager) {
        virtualFileManager.addVirtualFileManagerListener(new VirtualFileManagerListener(){

            public void beforeRefreshStart(boolean asynchonous) {
            }

            public void afterRefreshFinish(boolean asynchonous) {
                ProjectManagerImpl.this.scheduleReloadApplicationAndProject();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void askToReloadProjectIfConfigFilesChangedExternally() {
        if (this.myReloadBlockCount.get() == 0) {
            HashSet<Project> projects;
            Map<Project, List<Pair<VirtualFile, StateStorage>>> map = this.myChangedProjectFiles;
            synchronized (map) {
                if (this.myChangedProjectFiles.isEmpty()) {
                    return;
                }
                projects = new HashSet<Project>(this.myChangedProjectFiles.keySet());
            }
            ArrayList<Project> projectsToReload = new ArrayList<Project>();
            for (Project project : projects) {
                if (!this.shouldReloadProject(project)) continue;
                projectsToReload.add(project);
            }
            for (Project projectToReload : projectsToReload) {
                this.reloadProjectImpl(projectToReload, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToReloadApplication() {
        try {
            final Application app = ApplicationManager.getApplication();
            if (app.isDisposed()) {
                boolean bl = false;
                return bl;
            }
            final HashSet<Pair<VirtualFile, StateStorage>> causes = new HashSet<Pair<VirtualFile, StateStorage>>(this.myChangedApplicationFiles);
            if (causes.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            final boolean[] reloadOk = new boolean[]{false};
            final LinkedHashSet components = new LinkedHashSet();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        reloadOk[0] = ((ApplicationImpl)app).getStateStore().reload(causes, components);
                    }
                    catch (StateStorage.StateStorageException e) {
                        Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    }
                    catch (IOException e) {
                        Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    }
                }
            });
            if (!reloadOk[0] && !components.isEmpty()) {
                String message = "Application components were changed externally and cannot be reloaded:\n";
                for (String component : components) {
                    message = message + component + "\n";
                }
                boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
                message = message + "Would you like to " + (canRestart ? "restart " : "shutdown ");
                if (Messages.showYesNoDialog((String)(message = message + ApplicationNamesInfo.getInstance().getProductName() + "?"), (String)"Application Configuration Reload", (Icon)Messages.getQuestionIcon()) == 0) {
                    for (Pair<VirtualFile, StateStorage> cause : causes) {
                        StateStorage stateStorage = (StateStorage)cause.getSecond();
                        if (!(stateStorage instanceof XmlElementStorage)) continue;
                        ((XmlElementStorage)stateStorage).disableSaving();
                    }
                    if (canRestart) {
                        ApplicationManagerEx.getApplicationEx().restart();
                    } else {
                        ApplicationManagerEx.getApplicationEx().exit(true);
                    }
                }
            }
            boolean bl = reloadOk[0];
            return bl;
        }
        finally {
            this.myChangedApplicationFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldReloadProject(final Project project) {
        String message;
        if (project.isDisposed()) {
            return false;
        }
        final HashSet<Pair<VirtualFile, StateStorage>> causes = new HashSet<Pair<VirtualFile, StateStorage>>();
        Map<Project, List<Pair<VirtualFile, StateStorage>>> map = this.myChangedProjectFiles;
        synchronized (map) {
            List<Pair<VirtualFile, StateStorage>> changes = this.myChangedProjectFiles.remove(project);
            if (changes != null) {
                causes.addAll(changes);
            }
            if (causes.isEmpty()) {
                return false;
            }
        }
        final boolean[] reloadOk = new boolean[]{false};
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    reloadOk[0] = ((ProjectEx)project).getStateStore().reload(causes);
                }
                catch (StateStorage.StateStorageException e) {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                }
                catch (IOException e) {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                }
            }
        });
        if (reloadOk[0]) {
            return false;
        }
        if (causes.size() == 1) {
            message = ProjectBundle.message((String)"project.reload.external.change.single", (Object[])new Object[]{((VirtualFile)((Pair)causes.iterator().next()).first).getPresentableUrl()});
        } else {
            StringBuilder filesBuilder = new StringBuilder();
            boolean first = true;
            HashSet<String> alreadyShown = new HashSet<String>();
            for (Pair pair : causes) {
                String url = ((VirtualFile)pair.first).getPresentableUrl();
                if (alreadyShown.contains(url)) continue;
                if (!first) {
                    filesBuilder.append("\n");
                }
                first = false;
                filesBuilder.append(url);
                alreadyShown.add(url);
            }
            message = ProjectBundle.message((String)"project.reload.external.change.multiple", (Object[])new Object[]{filesBuilder.toString()});
        }
        return Messages.showYesNoDialog((Project)project, (String)message, (String)ProjectBundle.message((String)"project.reload.external.change.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @Override
    public boolean isFileSavedToBeReloaded(VirtualFile candidate) {
        return this.mySavedCopies.containsKey(candidate);
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
        this.myReloadBlockCount.incrementAndGet();
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
        if (this.myReloadBlockCount.decrementAndGet() == 0) {
            this.scheduleReloadApplicationAndProject();
        }
    }

    private void scheduleReloadApplicationAndProject() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ProjectManagerImpl.this.tryToReloadApplication()) {
                    return;
                }
                ProjectManagerImpl.this.askToReloadProjectIfConfigFilesChangedExternally();
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    public void setCurrentTestProject(@Nullable Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myCurrentTestProject = project;
    }

    @Override
    @Nullable
    public Project getCurrentTestProject() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myCurrentTestProject;
    }

    @Override
    public void saveChangedProjectFile(VirtualFile file, Project project) {
        if (file.exists()) {
            this.copyToTemp(file);
        }
        this.registerProjectToReload(project, file, null);
    }

    private void saveChangedProjectFile(VirtualFile file, Project project, StateStorage storage) {
        if (file.exists()) {
            this.copyToTemp(file);
        }
        this.registerProjectToReload(project, file, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProjectToReload(Project project, VirtualFile cause, StateStorage storage) {
        if (project != null) {
            Map<Project, List<Pair<VirtualFile, StateStorage>>> map = this.myChangedProjectFiles;
            synchronized (map) {
                List<Pair<VirtualFile, StateStorage>> changedProjectFiles = this.myChangedProjectFiles.get(project);
                if (changedProjectFiles == null) {
                    changedProjectFiles = new ArrayList<Pair<VirtualFile, StateStorage>>();
                    this.myChangedProjectFiles.put(project, changedProjectFiles);
                }
                changedProjectFiles.add((Pair<VirtualFile, StateStorage>)new Pair((Object)cause, (Object)storage));
            }
        } else {
            this.myChangedApplicationFiles.add((Pair<VirtualFile, StateStorage>)new Pair((Object)cause, (Object)storage));
        }
        this.myChangedFilesAlarm.cancelAllRequests();
        this.myChangedFilesAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (ProjectManagerImpl.this.myReloadBlockCount.get() == 0) {
                    ProjectManagerImpl.this.scheduleReloadApplicationAndProject();
                }
            }
        }, 444);
    }

    private void copyToTemp(VirtualFile file) {
        try {
            byte[] bytes = file.contentsToByteArray();
            this.mySavedCopies.put(file, bytes);
            this.mySavedTimestamps.put((Object)file, file.getTimeStamp());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCopy(VirtualFile file) {
        try {
            if (file == null) {
                return;
            }
            if (!file.isWritable()) {
                return;
            }
            byte[] bytes = this.mySavedCopies.get(file);
            if (bytes != null) {
                try {
                    file.setBinaryContent(bytes, -1L, this.mySavedTimestamps.get((Object)file));
                }
                catch (IOException e) {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.write.failed", (Object[])new Object[]{file.getPresentableUrl()}), (String)ProjectBundle.message((String)"project.reload.write.failed.title", (Object[])new Object[0]));
                }
            }
        }
        finally {
            this.mySavedCopies.remove(file);
            this.mySavedTimestamps.remove((Object)file);
        }
    }

    public void reloadProject(Project p) {
        this.reloadProjectImpl(p, true, false);
    }

    public void reloadProjectImpl(Project p, boolean clearCopyToRestore, boolean takeMemorySnapshot) {
        if (clearCopyToRestore) {
            this.mySavedCopies.clear();
            this.mySavedTimestamps.clear();
        }
        this.reloadProject(p, takeMemorySnapshot);
    }

    public void reloadProject(@NotNull Project p, boolean takeMemorySnapshot) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/impl/ProjectManagerImpl.reloadProject must not be null");
        }
        final Project[] project = new Project[]{p};
        ProjectReloadState.getInstance((Project)project[0]).onBeforeAutomaticProjectReload();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<IFile> original;
                LOG.info("Reloading project.");
                ProjectImpl projectImpl = (ProjectImpl)project[0];
                if (projectImpl.isDisposed()) {
                    return;
                }
                IProjectStore projectStore = projectImpl.getStateStore();
                String location = projectImpl.getLocation();
                try {
                    IComponentStore.SaveSession saveSession = projectStore.startSave();
                    original = saveSession.getAllStorageFiles(true);
                    saveSession.finishSave();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                if (project[0].isDisposed() || ProjectUtil.closeProject(project[0])) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            for (IFile originalFile : original) {
                                ProjectManagerImpl.this.restoreCopy(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(originalFile));
                            }
                        }
                    });
                    project[0] = null;
                    ProjectUtil.openProject(location, null, true);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(Project project) {
        return this.closeProject(project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeProject(Project project, boolean save) {
        if (!this.isProjectOpened(project)) {
            return true;
        }
        if (!this.canClose(project)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (save) {
                FileDocumentManager.getInstance().saveAllDocuments();
                project.save();
            }
            this.fireProjectClosing(project);
            this.myOpenProjects.remove(project);
            this.myChangedProjectFiles.remove(project);
            this.fireProjectClosed(project);
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    private void fireProjectClosing(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectClosing(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addProjectManagerListener(ProjectManagerListener listener) {
        this.myListeners.add(listener);
    }

    public void removeProjectManagerListener(ProjectManagerListener listener) {
        boolean removed = this.myListeners.remove(listener);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(Project project, ProjectManagerListener listener) {
        ArrayList<ProjectManagerListener> listeners = (ArrayList<ProjectManagerListener>)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = new ArrayList<ProjectManagerListener>();
            project.putUserData(LISTENERS_IN_PROJECT_KEY, listeners);
        }
        listeners.add(listener);
    }

    public void removeProjectManagerListener(Project project, ProjectManagerListener listener) {
        ArrayList listeners = (ArrayList)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners != null) {
            boolean removed = listeners.remove(listener);
            LOG.assertTrue(removed);
        } else {
            LOG.assertTrue(false);
        }
    }

    private void fireProjectOpened(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectOpened(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void fireProjectClosed(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                listener.projectClosed(project);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean canClose(Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener : this.myListeners) {
            try {
                if (listener.canCloseProject(project)) continue;
                return false;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return true;
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        if (this.myDefaultProject != null) {
            this.myDefaultProject.save();
        }
        if (this.myDefaultProjectRootElement == null) {
            this.myDefaultProjectRootElement = new Element(ELEMENT_DEFAULT_PROJECT);
        }
        this.myDefaultProjectRootElement.detach();
        parentNode.addContent(this.myDefaultProjectRootElement);
    }

    public void setDefaultProjectRootElement(Element defaultProjectRootElement) {
        this.myDefaultProjectRootElement = defaultProjectRootElement;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.myDefaultProjectRootElement = parentNode.getChild(ELEMENT_DEFAULT_PROJECT);
        if (this.myDefaultProjectRootElement == null) {
            this.myDefaultProjectRootElement = new Element(ELEMENT_DEFAULT_PROJECT);
        }
        this.myDefaultProjectRootElement.detach();
    }

    public String getExternalFileName() {
        return "project.default";
    }

    @NotNull
    public String getComponentName() {
        if ("ProjectManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectManagerImpl.getComponentName must not return null");
        }
        return "ProjectManager";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectManagerImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"project.default.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/impl/ProjectManagerImpl.getPresentableName must not return null");
        }
        return string;
    }
}

