/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class DumbModeIndicator
extends AbstractProjectComponent {
    private final Alarm myAlarm;

    public DumbModeIndicator(Project project) {
        super(project);
        this.myAlarm = new Alarm((Disposable)project);
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){
            BalloonHandler myHandler;

            public void enteredDumbMode() {
                DumbModeIndicator.this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        myHandler = DumbService.getInstance((Project)DumbModeIndicator.this.myProject).showDumbModeNotification("Updating project indices...<br>Refactorings, usage search and some other features will become available after indexing is complete");
                    }
                }, 1000);
            }

            public void exitDumbMode() {
                DumbModeIndicator.this.myAlarm.cancelAllRequests();
                if (this.myHandler != null) {
                    this.myHandler.hide();
                }
                this.myHandler = null;
            }
        });
    }

    @NotNull
    public String getComponentName() {
        String string = DumbModeIndicator.class.getSimpleName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/project/DumbModeIndicator.getComponentName must not return null");
        }
        return string;
    }
}

