/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class DefaultColorSchemesManager
implements ApplicationComponent,
JDOMExternalizable {
    private final ArrayList mySchemes = new ArrayList();
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";

    public String getComponentName() {
        return "DefaultColorSchemesManager";
    }

    public static DefaultColorSchemesManager getInstance() {
        return (DefaultColorSchemesManager)ApplicationManager.getApplication().getComponent(DefaultColorSchemesManager.class);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        List schemes = element.getChildren(SCHEME_ELEMENT);
        for (Element schemeElement : schemes) {
            DefaultColorsScheme newScheme = new DefaultColorsScheme(this);
            newScheme.readExternal(schemeElement);
            this.mySchemes.add(newScheme);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        throw new WriteExternalException();
    }

    public DefaultColorsScheme[] getAllSchemes() {
        return this.mySchemes.toArray(new DefaultColorsScheme[this.mySchemes.size()]);
    }

    public EditorColorsScheme getScheme(String name) {
        for (int i = 0; i < this.mySchemes.size(); ++i) {
            DefaultColorsScheme scheme = (DefaultColorsScheme)this.mySchemes.get(i);
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }
}

