/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ConflictChange;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeBuilder;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.SimpleChange;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.util.ContextLogger;
import com.intellij.openapi.diff.impl.util.GutterActionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.SequenceIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeList
implements ChangeList.Parent,
UserDataHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.MergeList");
    private final Project myProject;
    private final ChangeList[] myChanges = new ChangeList[2];
    private final UserDataHolderBase myDataHolder = new UserDataHolderBase();
    public static final FragmentSide BRANCH_SIDE = FragmentSide.SIDE2;
    public static final FragmentSide BASE_SIDE = FragmentSide.SIDE1;
    public static final DataKey<MergeList> DATA_KEY = DataKey.create((String)"mergeList");
    @Deprecated
    public static final String MERGE_LIST = DATA_KEY.getName();
    public static final Condition<Change> NOT_CONFLICTS = new Condition<Change>(){

        public boolean value(Change change) {
            return !(change instanceof ConflictChange);
        }
    };

    private MergeList(Project project, Document left, Document base, Document right) {
        this.myProject = project;
        this.myChanges[0] = new ChangeList(base, left, this);
        this.myChanges[1] = new ChangeList(base, right, this);
    }

    public static MergeList create(Project project, Document left, Document base, Document right) {
        MergeList mergeList = new MergeList(project, left, base, right);
        String leftText = left.getText();
        String baseText = base.getText();
        String rightText = right.getText();
        Object[] data = new Object[]{"Left\n" + leftText, "\nBase\n" + baseText, "\nRight\n" + rightText};
        ContextLogger logger = new ContextLogger(LOG, new ContextLogger.SimpleContext(data));
        List<MergeBuilder.MergeFragment> fragmentList = MergeList.processText(leftText, baseText, rightText, logger);
        ArrayList<Change> leftChanges = new ArrayList<Change>();
        ArrayList<Change> rightChanges = new ArrayList<Change>();
        int fragmentsListSize = fragmentList.size();
        for (int i = 0; i < fragmentsListSize; ++i) {
            MergeBuilder.MergeFragment mergeFragment = fragmentList.get(i);
            TextRange[] ranges = mergeFragment.getRanges();
            logger.assertTrue(ranges[1] != null);
            if (ranges[0] == null) {
                if (ranges[2] == null) {
                    if (i == fragmentsListSize - 1 && ranges[1].getEndOffset() == baseText.length()) {
                        int rightTextLength = rightText.length();
                        int leftTextLength = leftText.length();
                        rightChanges.add(SimpleChange.fromRanges(ranges[1], new TextRange(rightTextLength, rightTextLength), mergeList.myChanges[1]));
                        leftChanges.add(SimpleChange.fromRanges(ranges[1], new TextRange(leftTextLength, leftTextLength), mergeList.myChanges[0]));
                        continue;
                    }
                    LOG.error("Left Text: " + leftText + "\n" + "Right Text: " + rightText + "\nBase Text: " + baseText);
                    continue;
                }
                rightChanges.add(SimpleChange.fromRanges(ranges[1], ranges[2], mergeList.myChanges[1]));
                continue;
            }
            if (ranges[2] == null) {
                if (ranges[0] == null) {
                    LOG.error("Left Text: " + leftText + "\n" + "Right Text: " + rightText + "\nBase Text: " + baseText);
                }
                leftChanges.add(SimpleChange.fromRanges(ranges[1], ranges[0], mergeList.myChanges[0]));
                continue;
            }
            Change[] changes = MergeConflict.createChanges(ranges[0], ranges[1], ranges[2], mergeList);
            leftChanges.add(changes[0]);
            rightChanges.add(changes[1]);
        }
        mergeList.myChanges[0].setChanges(leftChanges);
        mergeList.myChanges[1].setChanges(rightChanges);
        return mergeList;
    }

    private static List<MergeBuilder.MergeFragment> processText(String leftText, String baseText, String rightText, ContextLogger logger) {
        DiffFragment[] leftFragments = DiffPolicy.DEFAULT_LINES.buildFragments(baseText, leftText);
        DiffFragment[] rightFragments = DiffPolicy.DEFAULT_LINES.buildFragments(baseText, rightText);
        int[] leftOffsets = new int[]{0, 0};
        int[] rightOffsets = new int[]{0, 0};
        int leftIndex = 0;
        int rightIndex = 0;
        MergeBuilder builder = new MergeBuilder(logger);
        while (leftIndex < leftFragments.length || rightIndex < rightFragments.length) {
            FragmentSide side;
            TextRange[] equalRanges = new TextRange[2];
            if (leftOffsets[0] < rightOffsets[0] && leftIndex < leftFragments.length) {
                side = FragmentSide.SIDE1;
                MergeList.getEqualRanges(leftFragments[leftIndex], leftOffsets, equalRanges);
                ++leftIndex;
            } else {
                if (rightIndex >= rightFragments.length) break;
                side = FragmentSide.SIDE2;
                MergeList.getEqualRanges(rightFragments[rightIndex], rightOffsets, equalRanges);
                ++rightIndex;
            }
            if (equalRanges[0] != null && equalRanges[1] != null) {
                builder.add(equalRanges[0], equalRanges[1], side);
                continue;
            }
            logger.assertTrue(equalRanges[0] == null && equalRanges[1] == null);
        }
        return builder.finish(leftText.length(), baseText.length(), rightText.length());
    }

    private static void getEqualRanges(DiffFragment fragment, int[] leftOffsets, TextRange[] equalRanges) {
        int baseLength = MergeList.getTextLength(fragment.getText1());
        int versionLength = MergeList.getTextLength(fragment.getText2());
        if (fragment.isEqual()) {
            equalRanges[0] = new TextRange(leftOffsets[0], leftOffsets[0] + baseLength);
            equalRanges[1] = new TextRange(leftOffsets[1], leftOffsets[1] + versionLength);
        } else {
            equalRanges[0] = null;
            equalRanges[1] = null;
        }
        leftOffsets[0] = leftOffsets[0] + baseLength;
        leftOffsets[1] = leftOffsets[1] + versionLength;
    }

    private static int getTextLength(String text1) {
        return text1 != null ? text1.length() : 0;
    }

    public static MergeList create(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        return MergeList.create(data.getProject(), contents[0].getDocument(), contents[1].getDocument(), contents[2].getDocument());
    }

    public void setMarkups(Editor left, Editor base, Editor right) {
        this.myChanges[0].setMarkup(base, left);
        this.myChanges[1].setMarkup(base, right);
        this.addActions(FragmentSide.SIDE1);
        this.addActions(FragmentSide.SIDE2);
    }

    public Iterator<Change> getAllChanges() {
        return SequenceIterator.create(this.myChanges[0].getChanges().iterator(), (Iterator)FilteringIterator.create(this.myChanges[1].getChanges().iterator(), NOT_CONFLICTS));
    }

    public void addListener(ChangeList.Listener listener) {
        for (ChangeList changeList : this.myChanges) {
            changeList.addListener(listener);
        }
    }

    public void removeListener(ChangeList.Listener listener) {
        for (ChangeList changeList : this.myChanges) {
            changeList.removeListener(listener);
        }
    }

    private void addActions(FragmentSide side) {
        ChangeList changeList = this.myChanges[side.getIndex()];
        FragmentSide originalSide = BRANCH_SIDE;
        for (int i = 0; i < changeList.getCount(); ++i) {
            final Change change = changeList.getChange(i);
            if (!change.canHasActions(originalSide)) continue;
            AnAction applyAction = new AnAction(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), null, GutterActionRenderer.REPLACE_ARROW){

                public void actionPerformed(AnActionEvent e) {
                    MergeList.apply(change);
                }
            };
            AnAction ignoreAction = new AnAction(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), null, GutterActionRenderer.REMOVE_CROSS){

                public void actionPerformed(AnActionEvent e) {
                    change.removeFromList();
                }
            };
            change.getChangeSide(originalSide).getHighlighterHolder().setActions(new AnAction[]{applyAction, ignoreAction});
        }
    }

    private static void apply(Change change) {
        Change.apply(change, BRANCH_SIDE);
    }

    public ChangeList getChanges(FragmentSide changesSide) {
        return this.myChanges[changesSide.getIndex()];
    }

    public void removeChanges(Change[] changes) {
        for (int i = 0; i < changes.length; ++i) {
            Change change = changes[i];
            this.myChanges[i].remove(change);
        }
    }

    public Document getBaseDocument() {
        Document document = this.myChanges[0].getDocument(BASE_SIDE);
        LOG.assertTrue(document == this.myChanges[1].getDocument(BASE_SIDE));
        return document;
    }

    @Nullable
    public static MergeList fromDataContext(DataContext dataContext) {
        MergeList mergeList = (MergeList)DATA_KEY.getData(dataContext);
        if (mergeList != null) {
            return mergeList;
        }
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        return mergePanel == null ? null : mergePanel.getMergeList();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/MergeList.getUserData must not be null");
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/MergeList.putUserData must not be null");
        }
        this.myDataHolder.putUserData(key, value);
    }

    public FragmentSide getSideOf(ChangeList source) {
        for (int i = 0; i < this.myChanges.length; ++i) {
            ChangeList changeList = this.myChanges[i];
            if (changeList != source) continue;
            return FragmentSide.fromIndex((int)i);
        }
        return null;
    }

    public void updateMarkup() {
        this.myChanges[0].updateMarkup();
        this.myChanges[1].updateMarkup();
    }
}

