/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import javax.swing.event.HyperlinkEvent;

public class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";

    public NotificationTestAction() {
        super("Add Test Notification");
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        MessageBus messageBus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
        long l = System.currentTimeMillis();
        NotificationType type = l % 3L == 0L ? NotificationType.ERROR : (l % 5L == 0L ? NotificationType.WARNING : NotificationType.INFORMATION);
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(Notification n, HyperlinkEvent e) {
                n.expire();
            }
        };
        Notification notification = new Notification(TEST_GROUP_ID, "This is a test notification", "You can close this notification by clicking <a href=\"close\">this link</a>.", type, listener);
        ((Notifications)messageBus.syncPublisher(Notifications.TOPIC)).notify(notification);
    }
}

