/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class MockVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private final MyVirtualFile myRoot = new MyVirtualFile("", null);
    public static final String PROTOCOL = "mock";

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.findFileByPath must not be null");
        }
        path = path.replace(File.separatorChar, '/');
        if (StringUtil.startsWithChar((CharSequence)(path = path.replace('/', ':')), (char)':')) {
            path = path.substring(1);
        }
        String[] components = path.split(":");
        MyVirtualFile file = this.myRoot;
        for (String component : components) {
            file = file.getOrCreate(component);
        }
        return file;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockVirtualFileSystem.getProtocol must not return null");
        }
        return PROTOCOL;
    }

    public void refresh(boolean asynchronous) {
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.deleteFile must not be null");
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.moveFile must not be null");
        }
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.copyFile must not be null");
        }
        return null;
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.renameFile must not be null");
        }
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.createChildFile must not be null");
        }
        return null;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.createChildDirectory must not be null");
        }
        throw new IOException();
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockVirtualFileSystem.refreshAndFindFileByPath must not be null");
        }
        return this.findFileByPath(path);
    }

    public class MyVirtualFile
    extends LightVirtualFile {
        private final HashMap<String, MyVirtualFile> myChildren;
        private final MyVirtualFile myParent;

        public MyVirtualFile(String name, MyVirtualFile parent) {
            super(name);
            this.myChildren = new HashMap();
            this.myParent = parent;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            MockVirtualFileSystem mockVirtualFileSystem = MockVirtualFileSystem.this;
            if (mockVirtualFileSystem == null) {
                throw new IllegalStateException("@NotNull method com/intellij/mock/MockVirtualFileSystem$MyVirtualFile.getFileSystem must not return null");
            }
            return mockVirtualFileSystem;
        }

        public MyVirtualFile getOrCreate(String name) {
            MyVirtualFile file = this.myChildren.get(name);
            if (file == null) {
                file = new MyVirtualFile(name, this);
                this.myChildren.put(name, file);
            }
            return file;
        }

        public boolean isDirectory() {
            return this.myChildren.size() != 0;
        }

        public String getPath() {
            MyVirtualFile parent = this.getParent();
            return parent == null ? this.getName() : parent.getPath() + "/" + this.getName();
        }

        public MyVirtualFile getParent() {
            return this.myParent;
        }

        public VirtualFile[] getChildren() {
            Collection<MyVirtualFile> children = this.myChildren.values();
            return (VirtualFile[])children.toArray(new MyVirtualFile[children.size()]);
        }
    }
}

