/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class FrameworksTree
extends CheckboxTree {
    private boolean myProcessingMouseEventOnCheckbox;

    public FrameworksTree(List<List<FrameworkSupportNode>> groups) {
        super(new FrameworksTreeRenderer(), new FrameworksRootNode(groups), new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        TreeUtil.expandAll((JTree)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMouseEvent(MouseEvent e) {
        Object node;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null && (node = path.getLastPathComponent()) instanceof FrameworkSupportNode) {
            Rectangle checkboxBounds = ((CheckboxTreeBase.CheckboxTreeCellRendererBase)this.getCellRenderer()).myCheckbox.getBounds();
            Rectangle pathBounds = this.getPathBounds(path);
            checkboxBounds.setLocation(pathBounds.getLocation());
            if (checkboxBounds.contains(e.getPoint())) {
                try {
                    this.myProcessingMouseEventOnCheckbox = true;
                    super.processMouseEvent(e);
                }
                finally {
                    this.myProcessingMouseEventOnCheckbox = false;
                }
                return;
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isProcessingMouseEventOnCheckbox() {
        return this.myProcessingMouseEventOnCheckbox;
    }

    private static class FrameworksRootNode
    extends CheckedTreeNode {
        public FrameworksRootNode(List<List<FrameworkSupportNode>> groups) {
            super(null);
            for (List<FrameworkSupportNode> group : groups) {
                for (FrameworkSupportNode node : group) {
                    this.add((MutableTreeNode)((Object)node));
                }
            }
        }
    }

    private static class FrameworksTreeRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private FrameworksTreeRenderer() {
            super(true, false);
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof FrameworkSupportNode) {
                FrameworkSupportNode node = (FrameworkSupportNode)((Object)value);
                this.getTextRenderer().append(node.getTitle());
                this.getTextRenderer().setIcon(node.getProvider().getIcon());
            }
        }
    }
}

