/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ModuleGroup {
    public static final DataKey<ModuleGroup[]> ARRAY_DATA_KEY = DataKey.create((String)"moduleGroup.array");
    private final String[] myGroupPath;

    public ModuleGroup(@NotNull String[] groupPath) {
        if (groupPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/ModuleGroup.<init> must not be null");
        }
        this.myGroupPath = groupPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroup)) {
            return false;
        }
        ModuleGroup moduleGroup = (ModuleGroup)o;
        return Arrays.equals(this.myGroupPath, moduleGroup.myGroupPath);
    }

    public int hashCode() {
        return this.myGroupPath[this.myGroupPath.length - 1].hashCode();
    }

    public String[] getGroupPath() {
        return this.myGroupPath;
    }

    @NotNull
    public Collection<Module> modulesInGroup(Project project, boolean recursively) {
        Module[] allModules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : allModules) {
            Object[] group = ModuleManager.getInstance((Project)project).getModuleGroupPath(module);
            if (group == null || !Arrays.equals(this.myGroupPath, group) && (!recursively || !ModuleGroup.isChild(this.myGroupPath, (String[])group))) continue;
            result.add(module);
        }
        ArrayList<Module> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/ModuleGroup.modulesInGroup must not return null");
        }
        return arrayList;
    }

    public Collection<ModuleGroup> childGroups(Project project) {
        return this.childGroups(null, project);
    }

    public Collection<ModuleGroup> childGroups(DataContext dataContext) {
        return this.childGroups((ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext), (Project)PlatformDataKeys.PROJECT.getData(dataContext));
    }

    public Collection<ModuleGroup> childGroups(ModifiableModuleModel model, Project project) {
        Module[] allModules = model != null ? model.getModules() : ModuleManager.getInstance((Project)project).getModules();
        THashSet result = new THashSet();
        for (Module module : allModules) {
            String[] directChild;
            String[] group = model != null ? model.getModuleGroupPath(module) : ModuleManager.getInstance((Project)project).getModuleGroupPath(module);
            if (group == null || (directChild = ModuleGroup.directChild(this.myGroupPath, group)) == null) continue;
            result.add(new ModuleGroup(directChild));
        }
        return result;
    }

    private static boolean isChild(String[] parent, String[] descendant) {
        if (parent.length >= descendant.length) {
            return false;
        }
        for (int i = 0; i < parent.length; ++i) {
            String group = parent[i];
            if (group.equals(descendant[i])) continue;
            return false;
        }
        return true;
    }

    private static String[] directChild(String[] parent, String[] descendant) {
        if (!ModuleGroup.isChild(parent, descendant)) {
            return null;
        }
        return (String[])ArrayUtil.append((Object[])parent, (Object)descendant[parent.length]);
    }

    public String presentableText() {
        return "'" + this.myGroupPath[this.myGroupPath.length - 1] + "'";
    }

    public String toString() {
        return this.myGroupPath[this.myGroupPath.length - 1];
    }
}

