/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class DeleteFavoritesListAction
extends AnAction
implements DumbAware {
    public DeleteFavoritesListAction() {
        super(IdeBundle.message((String)"action.delete.favorites.list", (Object[])new Object[]{""}));
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        if (listName != null) {
            favoritesManager.removeFavoritesList(listName);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        e.getPresentation().setEnabled(listName != null && !listName.equals(project.getName()));
        if (listName != null) {
            e.getPresentation().setText(IdeBundle.message((String)"action.delete.favorites.list", (Object[])new Object[]{listName}));
            e.getPresentation().setDescription(IdeBundle.message((String)"action.delete.favorites.list", (Object[])new Object[]{listName}));
        }
    }
}

