/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFromTemplateDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateFileFromTemplateDialog");
    private JTextField myNameField;
    private JComboBox myKindCombo;
    private JPanel myPanel;
    private JLabel myUpDownHint;
    private ElementCreator myCreator;

    private CreateFileFromTemplateDialog(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog.<init> must not be null");
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myKindCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    LOG.error("Model: " + list.getModel().toString());
                }
                Trinity _value = (Trinity)value;
                this.setText((String)_value.first);
                this.setIcon((Icon)_value.second);
                return this;
            }
        });
        this.setTitle(title);
        new ComboboxSpeedSearch(this.myKindCombo){

            @Override
            protected String getElementText(Object element) {
                return (String)((Trinity)element).first;
            }
        };
        AnAction arrow = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    int delta = code == 40 ? 1 : (code == 38 ? -1 : 0);
                    int size = CreateFileFromTemplateDialog.this.myKindCombo.getModel().getSize();
                    int next = CreateFileFromTemplateDialog.this.myKindCombo.getSelectedIndex() + delta;
                    if (next < 0 || next >= size) {
                        if (!UISettings.getInstance().CYCLE_SCROLLING) {
                            return;
                        }
                        next = (next + size) % size;
                    }
                    CreateFileFromTemplateDialog.this.myKindCombo.setSelectedIndex(next);
                }
            }
        };
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        arrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myNameField);
        this.myUpDownHint.setIcon(Icons.UP_DOWN_ARROWS);
        this.init();
    }

    private String getEnteredName() {
        return this.myNameField.getText();
    }

    private String getTemplateName() {
        Trinity trinity = (Trinity)this.myKindCombo.getSelectedItem();
        if (trinity == null) {
            LOG.error("Model: " + this.myKindCombo.getModel());
        }
        return (String)trinity.third;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        if (this.myCreator.tryCreate(this.getEnteredName()).length == 0) {
            return;
        }
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public static <T extends PsiElement> Builder createDialog(final @NotNull Project project, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog.createDialog must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog.createDialog must not be null");
        }
        final CreateFileFromTemplateDialog dialog = new CreateFileFromTemplateDialog(project, title);
        return new Builder(){

            @Override
            public Builder addKind(@NotNull String name, @Nullable Icon icon, @NotNull String templateName) {
                if (name == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog$4.addKind must not be null");
                }
                if (templateName == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog$4.addKind must not be null");
                }
                dialog.myKindCombo.addItem(new Trinity((Object)name, (Object)icon, (Object)templateName));
                return this;
            }

            @Override
            public <T extends PsiElement> T show(@NotNull String errorTitle, final @NotNull FileCreator<T> creator) {
                if (errorTitle == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog$4.show must not be null");
                }
                if (creator == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateFileFromTemplateDialog$4.show must not be null");
                }
                final Ref created = Ref.create(null);
                dialog.myCreator = new ElementCreator(project, errorTitle){

                    protected void checkBeforeCreate(String newName) throws IncorrectOperationException {
                        creator.checkBeforeCreate(newName, dialog.getTemplateName());
                    }

                    protected PsiElement[] create(String newName) throws Exception {
                        PsiElement element = (PsiElement)creator.createFile(dialog.getEnteredName(), dialog.getTemplateName());
                        created.set((Object)element);
                        if (element != null) {
                            return new PsiElement[]{element};
                        }
                        return PsiElement.EMPTY_ARRAY;
                    }

                    protected String getActionName(String newName) {
                        return creator.getActionName(newName, dialog.getTemplateName());
                    }
                };
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    return (T)((PsiElement)created.get());
                }
                return null;
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Name:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Kind:");
        jLabel3.setDisplayedMnemonic('K');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKindCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(30);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the kind");
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface FileCreator<T> {
        public void checkBeforeCreate(@NotNull String var1, @NotNull String var2) throws IncorrectOperationException;

        @Nullable
        public T createFile(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String getActionName(@NotNull String var1, @NotNull String var2);
    }

    public static interface Builder {
        public Builder addKind(@NotNull String var1, @Nullable Icon var2, @NotNull String var3);

        @Nullable
        public <T extends PsiElement> T show(@NotNull String var1, @NotNull FileCreator<T> var2);
    }
}

