/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting.facetsTree;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManager;
import com.intellij.facet.impl.autodetecting.facetsTree.DetectedFacetsTree;
import com.intellij.facet.impl.ui.FacetDetectionProcessor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public class DetectedFacetsTreeComponent {
    private final JPanel myMainPanel;
    private final List<ModuleDescriptorNode> myModuleNodes = new ArrayList<ModuleDescriptorNode>();

    public DetectedFacetsTreeComponent() {
        this.myMainPanel = new JPanel(new BorderLayout());
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void addFacets(ModuleDescriptor moduleDescriptor, Map<File, List<FacetDetectionProcessor.DetectedInWizardFacetInfo>> root2Facets) {
        for (File root : root2Facets.keySet()) {
            ModuleDescriptorNode moduleNode = new ModuleDescriptorNode(moduleDescriptor, root);
            HashMap<FacetInfo, FacetInfoNode> facetInfos = new HashMap<FacetInfo, FacetInfoNode>();
            for (FacetDetectionProcessor.DetectedInWizardFacetInfo detectedFacetInfo : root2Facets.get(root)) {
                DetectedFacetsTree.FacetNode parent = null;
                FacetInfo underlyingFacet = detectedFacetInfo.getFacetInfo().getUnderlyingFacet();
                if (underlyingFacet != null) {
                    parent = (DetectedFacetsTree.FacetNode)((Object)facetInfos.get(underlyingFacet));
                }
                VirtualFile virtualRoot = LocalFileSystem.getInstance().findFileByIoFile(root);
                FacetInfoNode detectedFacet = new FacetInfoNode(detectedFacetInfo, virtualRoot, parent);
                facetInfos.put(detectedFacetInfo.getFacetInfo(), detectedFacet);
                if (parent != null) continue;
                moduleNode.addRootFacet(detectedFacet);
            }
            this.myModuleNodes.add(moduleNode);
        }
    }

    public void createTree() {
        DetectedFacetsTree tree = new DetectedFacetsTree(this.myModuleNodes);
        TreeUtil.expandAll((JTree)((Object)tree));
        this.myMainPanel.add((Component)((Object)tree), "Center");
    }

    public void clear() {
        this.myMainPanel.removeAll();
        this.myModuleNodes.clear();
    }

    public void createFacets(ModuleDescriptor descriptor, Module module, ModifiableRootModel rootModel) {
        ArrayList<Pair<FacetDetector, Facet>> createdFacets = new ArrayList<Pair<FacetDetector, Facet>>();
        ModifiableFacetModel modifiableModel = FacetManager.getInstance((Module)module).createModifiableModel();
        for (ModuleDescriptorNode moduleDescriptorNode : this.myModuleNodes) {
            if (!moduleDescriptorNode.myModuleDescriptor.equals(descriptor)) continue;
            DetectedFacetsTreeComponent.processFacetsInfos(moduleDescriptorNode.getRootFacets(), module, rootModel, modifiableModel, null, createdFacets, moduleDescriptorNode.isChecked());
        }
        modifiableModel.commit();
        for (Pair pair : createdFacets) {
            ((FacetDetector)pair.getFirst()).afterFacetAdded((Facet)pair.getSecond());
        }
    }

    private static void processFacetsInfos(List<DetectedFacetsTree.FacetNode> facets, Module module, ModifiableRootModel rootModel, ModifiableFacetModel facetModel, Facet underlyingFacet, List<Pair<FacetDetector, Facet>> createdFacets, boolean createFacets) {
        for (DetectedFacetsTree.FacetNode facetNode : facets) {
            boolean createFacet = createFacets && facetNode.isChecked();
            FacetDetectionProcessor.DetectedInWizardFacetInfo detectedFacetInfo = ((FacetInfoNode)facetNode).getDetectedFacetInfo();
            FacetInfo facetInfo = detectedFacetInfo.getFacetInfo();
            FacetType type = facetInfo.getFacetType();
            Facet facet = null;
            if (createFacet) {
                facet = FacetManager.getInstance((Module)module).createFacet(type, facetInfo.getName(), facetInfo.getConfiguration(), underlyingFacet);
                FacetDetector facetDetector = detectedFacetInfo.getFacetDetector();
                facetDetector.beforeFacetAdded(facet, (FacetModel)facetModel, rootModel);
                facetModel.addFacet(facet);
                createdFacets.add((Pair<FacetDetector, Facet>)Pair.create((Object)facetDetector, (Object)facet));
            } else {
                VirtualFile[] files = facetNode.getFiles();
                String[] urls = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    urls[i] = files[i].getUrl();
                }
                FacetAutodetectingManager.getInstance(module.getProject()).disableAutodetectionInFiles(type, module, urls);
            }
            DetectedFacetsTreeComponent.processFacetsInfos(facetNode.getChildren(), module, rootModel, facetModel, facet, createdFacets, createFacet);
        }
    }

    private static class ModuleDescriptorNode
    extends DetectedFacetsTree.ModuleNode {
        private final ModuleDescriptor myModuleDescriptor;
        private final File myRoot;

        private ModuleDescriptorNode(ModuleDescriptor moduleDescriptor, File root) {
            super(moduleDescriptor);
            this.myModuleDescriptor = moduleDescriptor;
            this.myRoot = root;
        }

        @Override
        public String getModuleName() {
            return this.myModuleDescriptor.getName();
        }

        @Override
        public String getModuleDescription() {
            return " (" + this.myRoot.getPath() + ")";
        }
    }

    private static class FacetInfoNode
    extends DetectedFacetsTree.FacetNode {
        private final FacetDetectionProcessor.DetectedInWizardFacetInfo myDetectedFacetInfo;

        private FacetInfoNode(FacetDetectionProcessor.DetectedInWizardFacetInfo detectedFacetInfo, VirtualFile root, @Nullable DetectedFacetsTree.FacetNode parent) {
            super(detectedFacetInfo.getFacetInfo(), detectedFacetInfo.getFacetInfo().getFacetType(), root, new VirtualFile[]{detectedFacetInfo.getFile()}, parent);
            this.myDetectedFacetInfo = detectedFacetInfo;
        }

        public FacetDetectionProcessor.DetectedInWizardFacetInfo getDetectedFacetInfo() {
            return this.myDetectedFacetInfo;
        }
    }
}

