/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.ui.RegistryCheckBox;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.classFilter.ClassFilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DebuggerDataViewsConfigurable
implements SearchableConfigurable {
    private JCheckBox myCbAutoscroll;
    private JCheckBox myCbShowSyntheticFields;
    private JCheckBox myCbSort;
    private JCheckBox myCbHideNullArrayElements;
    private JCheckBox myCbShowStatic;
    private JCheckBox myCbShowDeclaredType;
    private JCheckBox myCbShowObjectId;
    private StateRestoringCheckBox myCbShowStaticFinalFields;
    private final ArrayRendererConfigurable myArrayRendererConfigurable;
    private JCheckBox myCbEnableAlternateViews;
    private JCheckBox myCbEnableToString;
    private JRadioButton myRbAllThatOverride;
    private JRadioButton myRbFromList;
    private ClassFilterEditor myToStringFilterEditor;
    private JTextField myValueTooltipDelayField;
    private final Project myProject;
    private RegistryCheckBox myAutoTooltip;

    public DebuggerDataViewsConfigurable(Project project) {
        this.myProject = project;
        this.myArrayRendererConfigurable = new ArrayRendererConfigurable(NodeRendererSettings.getInstance().getArrayRenderer());
    }

    public void disposeUIResources() {
        this.myArrayRendererConfigurable.disposeUIResources();
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"base.renderer.configurable.display.name", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbAutoscroll = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.autoscroll", (Object[])new Object[0]));
        this.myCbShowSyntheticFields = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.synthetic.fields", (Object[])new Object[0]));
        this.myCbSort = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.sort.alphabetically", (Object[])new Object[0]));
        this.myCbHideNullArrayElements = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.hide.null.array.elements", (Object[])new Object[0]));
        this.myCbShowStatic = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.static.fields", (Object[])new Object[0]));
        this.myCbShowStaticFinalFields = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.static.final.fields", (Object[])new Object[0]));
        this.myCbEnableAlternateViews = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.alternate.view", (Object[])new Object[0]));
        this.myCbShowStatic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DebuggerDataViewsConfigurable.this.myCbShowStatic.isSelected()) {
                    DebuggerDataViewsConfigurable.this.myCbShowStaticFinalFields.makeSelectable();
                } else {
                    DebuggerDataViewsConfigurable.this.myCbShowStaticFinalFields.makeUnselectable(false);
                }
            }
        });
        this.myCbShowDeclaredType = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.declared.type", (Object[])new Object[0]));
        this.myCbShowObjectId = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.object.id", (Object[])new Object[0]));
        this.myCbEnableToString = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.enable.tostring", (Object[])new Object[0]));
        this.myRbAllThatOverride = new JRadioButton(DebuggerBundle.message((String)"label.base.renderer.configurable.all.overridding", (Object[])new Object[0]));
        this.myRbFromList = new JRadioButton(DebuggerBundle.message((String)"label.base.renderer.configurable.classes.from.list", (Object[])new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbAllThatOverride);
        group.add(this.myRbFromList);
        this.myToStringFilterEditor = new ClassFilterEditor(this.myProject);
        this.myCbEnableToString.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = DebuggerDataViewsConfigurable.this.myCbEnableToString.isSelected();
                DebuggerDataViewsConfigurable.this.myRbAllThatOverride.setEnabled(enabled);
                DebuggerDataViewsConfigurable.this.myRbFromList.setEnabled(enabled);
                DebuggerDataViewsConfigurable.this.myToStringFilterEditor.setEnabled(enabled && DebuggerDataViewsConfigurable.this.myRbFromList.isSelected());
            }
        });
        this.myRbFromList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DebuggerDataViewsConfigurable.this.myToStringFilterEditor.setEnabled(DebuggerDataViewsConfigurable.this.myCbEnableToString.isSelected() && DebuggerDataViewsConfigurable.this.myRbFromList.isSelected());
            }
        });
        panel.add((Component)this.myCbSort, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 6, 0, 0), 0, 0));
        panel.add((Component)this.myCbAutoscroll, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 6, 0, 0), 0, 0));
        this.myAutoTooltip = new RegistryCheckBox(Registry.get((String)"debugger.valueTooltipAutoShow"), DebuggerBundle.message((String)"label.base.renderer.configurable.autoTooltip", (Object[])new Object[0]), DebuggerBundle.message((String)"label.base.renderer.configurable.autoTooltip.description", (Object[])new Object[]{Registry.stringValue((String)"ide.forcedShowTooltip")}));
        panel.add((Component)this.myAutoTooltip, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 6, 0, 0), 0, 0));
        JLabel tooltipLabel = new JLabel(DebuggerBundle.message((String)"label.debugger.general.configurable.tooltips.delay", (Object[])new Object[0]));
        panel.add((Component)tooltipLabel, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.myValueTooltipDelayField = new JTextField(10);
        this.myValueTooltipDelayField.setMinimumSize(new Dimension(50, this.myValueTooltipDelayField.getPreferredSize().height));
        panel.add((Component)this.myValueTooltipDelayField, new GridBagConstraints(2, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 6, 0, 0), 0, 0));
        tooltipLabel.setLabelFor(this.myValueTooltipDelayField);
        JPanel showPanel = new JPanel(new GridBagLayout());
        showPanel.setBorder(BorderFactory.createTitledBorder("Show"));
        showPanel.add((Component)this.myCbShowDeclaredType, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowObjectId, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowSyntheticFields, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowStatic, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowStaticFinalFields, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        panel.add((Component)showPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 6, 0, 0), 0, 0));
        JPanel arraysPanel = new JPanel(new BorderLayout());
        JComponent arraysComponent = this.myArrayRendererConfigurable.createComponent();
        arraysComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        arraysPanel.add((Component)arraysComponent, "Center");
        arraysPanel.add((Component)this.myCbHideNullArrayElements, "South");
        arraysPanel.setBorder(BorderFactory.createTitledBorder("Arrays"));
        panel.add((Component)arraysPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, new Insets(4, 6, 0, 0), 0, 0));
        panel.add((Component)this.myCbEnableAlternateViews, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 6, 0, 10), 0, 0));
        panel.add((Component)this.myCbEnableToString, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, new Insets(4, 6, 0, 0), 0, 0));
        panel.add((Component)this.myRbAllThatOverride, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        panel.add((Component)this.myRbFromList, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        panel.add((Component)this.myToStringFilterEditor, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 0), 0, 0));
        return panel;
    }

    public Icon getIcon() {
        return null;
    }

    public void apply() {
        ViewsGeneralSettings generalSettings = ViewsGeneralSettings.getInstance();
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        try {
            DebuggerSettings.getInstance().VALUE_LOOKUP_DELAY = Integer.parseInt(this.myValueTooltipDelayField.getText().trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        generalSettings.AUTOSCROLL_TO_NEW_LOCALS = this.myCbAutoscroll.isSelected();
        rendererSettings.setAlternateCollectionViewsEnabled(this.myCbEnableAlternateViews.isSelected());
        generalSettings.HIDE_NULL_ARRAY_ELEMENTS = this.myCbHideNullArrayElements.isSelected();
        ClassRenderer classRenderer = rendererSettings.getClassRenderer();
        classRenderer.SORT_ASCENDING = this.myCbSort.isSelected();
        classRenderer.SHOW_STATIC = this.myCbShowStatic.isSelected();
        classRenderer.SHOW_STATIC_FINAL = this.myCbShowStaticFinalFields.isSelectedWhenSelectable();
        classRenderer.SHOW_SYNTHETICS = this.myCbShowSyntheticFields.isSelected();
        classRenderer.SHOW_DECLARED_TYPE = this.myCbShowDeclaredType.isSelected();
        classRenderer.SHOW_OBJECT_ID = this.myCbShowObjectId.isSelected();
        ToStringRenderer toStringRenderer = rendererSettings.getToStringRenderer();
        toStringRenderer.setEnabled(this.myCbEnableToString.isSelected());
        toStringRenderer.setUseClassFilters(this.myRbFromList.isSelected());
        toStringRenderer.setClassFilters(this.myToStringFilterEditor.getFilters());
        this.myAutoTooltip.save();
        this.myArrayRendererConfigurable.apply();
    }

    public void reset() {
        ViewsGeneralSettings generalSettings = ViewsGeneralSettings.getInstance();
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        this.myValueTooltipDelayField.setText(Integer.toString(DebuggerSettings.getInstance().VALUE_LOOKUP_DELAY));
        this.myCbAutoscroll.setSelected(generalSettings.AUTOSCROLL_TO_NEW_LOCALS);
        this.myCbHideNullArrayElements.setSelected(generalSettings.HIDE_NULL_ARRAY_ELEMENTS);
        this.myCbEnableAlternateViews.setSelected(rendererSettings.areAlternateCollectionViewsEnabled());
        ClassRenderer classRenderer = rendererSettings.getClassRenderer();
        this.myCbShowSyntheticFields.setSelected(classRenderer.SHOW_SYNTHETICS);
        this.myCbSort.setSelected(classRenderer.SORT_ASCENDING);
        this.myCbShowStatic.setSelected(classRenderer.SHOW_STATIC);
        this.myCbShowStaticFinalFields.setSelected(classRenderer.SHOW_STATIC_FINAL);
        if (!classRenderer.SHOW_STATIC) {
            this.myCbShowStaticFinalFields.makeUnselectable(false);
        }
        this.myCbShowDeclaredType.setSelected(classRenderer.SHOW_DECLARED_TYPE);
        this.myCbShowObjectId.setSelected(classRenderer.SHOW_OBJECT_ID);
        ToStringRenderer toStringRenderer = rendererSettings.getToStringRenderer();
        boolean toStringEnabled = toStringRenderer.isEnabled();
        boolean useClassFilters = toStringRenderer.isUseClassFilters();
        this.myCbEnableToString.setSelected(toStringEnabled);
        this.myRbAllThatOverride.setSelected(!useClassFilters);
        this.myRbFromList.setSelected(useClassFilters);
        this.myToStringFilterEditor.setFilters(toStringRenderer.getClassFilters());
        this.myToStringFilterEditor.setEnabled(toStringEnabled && useClassFilters);
        this.myRbFromList.setEnabled(toStringEnabled);
        this.myRbAllThatOverride.setEnabled(toStringEnabled);
        this.myArrayRendererConfigurable.reset();
    }

    public boolean isModified() {
        return this.areGeneralSettingsModified() || this.areDefaultRenderersModified() || this.areDebuggerSettingsModified();
    }

    private boolean areDebuggerSettingsModified() {
        try {
            return DebuggerSettings.getInstance().VALUE_LOOKUP_DELAY != Integer.parseInt(this.myValueTooltipDelayField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean areGeneralSettingsModified() {
        ViewsGeneralSettings generalSettings = ViewsGeneralSettings.getInstance();
        return generalSettings.AUTOSCROLL_TO_NEW_LOCALS != this.myCbAutoscroll.isSelected() || generalSettings.HIDE_NULL_ARRAY_ELEMENTS != this.myCbHideNullArrayElements.isSelected() || this.myAutoTooltip.isChanged();
    }

    private boolean areDefaultRenderersModified() {
        boolean isToStringRendererModified;
        boolean isClassRendererModified;
        if (this.myArrayRendererConfigurable.isModified()) {
            return true;
        }
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        ClassRenderer classRenderer = rendererSettings.getClassRenderer();
        boolean bl = isClassRendererModified = classRenderer.SORT_ASCENDING != this.myCbSort.isSelected() || classRenderer.SHOW_STATIC != this.myCbShowStatic.isSelected() || classRenderer.SHOW_STATIC_FINAL != this.myCbShowStaticFinalFields.isSelectedWhenSelectable() || classRenderer.SHOW_SYNTHETICS != this.myCbShowSyntheticFields.isSelected() || classRenderer.SHOW_DECLARED_TYPE != this.myCbShowDeclaredType.isSelected() || classRenderer.SHOW_OBJECT_ID != this.myCbShowObjectId.isSelected();
        if (isClassRendererModified) {
            return true;
        }
        ToStringRenderer toStringRenderer = rendererSettings.getToStringRenderer();
        boolean bl2 = isToStringRendererModified = toStringRenderer.isEnabled() != this.myCbEnableToString.isSelected() || toStringRenderer.isUseClassFilters() != this.myRbFromList.isSelected() || !DebuggerUtilsEx.filterEquals(toStringRenderer.getClassFilters(), this.myToStringFilterEditor.getFilters());
        if (isToStringRendererModified) {
            return true;
        }
        return rendererSettings.areAlternateCollectionViewsEnabled() != this.myCbEnableAlternateViews.isSelected();
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.dataviews";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

