/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FieldCanBeLocalInspection
extends BaseLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.varScopeCanBeNarrowed.FieldCanBeLocalInspection");
    @NonNls
    public static final String SHORT_NAME = "FieldCanBeLocal";

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASSLAYOUT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.field.can.be.local.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitJavaFile(PsiJavaFile file) {
                for (PsiClass aClass : file.getClasses()) {
                    FieldCanBeLocalInspection.docheckClass(aClass, holder);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private static void docheckClass(PsiClass aClass, ProblemsHolder holder) {
        if (aClass.isInterface()) {
            return;
        }
        PsiField[] fields = aClass.getFields();
        LinkedHashSet<PsiField> candidates = new LinkedHashSet<PsiField>();
        for (PsiField field : fields) {
            if (!field.hasModifierProperty("private") || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
            candidates.add(field);
        }
        FieldCanBeLocalInspection.removeFieldsReferencedFromInitializers(aClass, candidates);
        if (candidates.isEmpty()) {
            return;
        }
        THashSet usedFields = new THashSet();
        FieldCanBeLocalInspection.removeReadFields(aClass, candidates, (Set<PsiField>)usedFields);
        if (candidates.isEmpty()) {
            return;
        }
        ImplicitUsageProvider[] implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);
        for (PsiField field : candidates) {
            if (!usedFields.contains(field) || FieldCanBeLocalInspection.hasImplicitReadOrWriteUsage(field, implicitUsageProviders)) continue;
            String message = InspectionsBundle.message((String)"inspection.field.can.be.local.problem.descriptor", (Object[])new Object[0]);
            holder.registerProblem((PsiElement)field.getNameIdentifier(), message, new LocalQuickFix[]{new MyQuickFix(field)});
        }
    }

    private static void removeReadFields(PsiClass aClass, final Set<PsiField> candidates, final Set<PsiField> usedFields) {
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!candidates.isEmpty()) {
                    super.visitElement(element);
                }
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    FieldCanBeLocalInspection.checkCodeBlock(body, candidates, usedFields);
                }
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                super.visitClassInitializer(initializer);
                FieldCanBeLocalInspection.checkCodeBlock(initializer.getBody(), candidates, usedFields);
            }
        });
    }

    private static void checkCodeBlock(PsiCodeBlock body, Set<PsiField> candidates, Set<PsiField> usedFields) {
        try {
            ControlFlow controlFlow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow((PsiElement)body, AllVariablesControlFlowPolicy.getInstance());
            List<PsiVariable> usedVars = ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize());
            for (PsiVariable usedVariable : usedVars) {
                PsiField usedField;
                if (!(usedVariable instanceof PsiField) || usedFields.add(usedField = (PsiField)usedVariable)) continue;
                candidates.remove(usedField);
            }
            Ref writtenVariables = new Ref();
            List<PsiReferenceExpression> readBeforeWrites = ControlFlowUtil.getReadBeforeWrite(controlFlow);
            for (PsiReferenceExpression readBeforeWrite : readBeforeWrites) {
                PsiElement parent;
                PsiField field;
                PsiElement resolved = readBeforeWrite.resolve();
                if (!(resolved instanceof PsiField) || (field = (PsiField)resolved).getType() instanceof PsiPrimitiveType && PsiUtil.isConstantExpression((PsiExpression)field.getInitializer()) && !FieldCanBeLocalInspection.getWrittenVariables(controlFlow, (Ref<Collection<PsiVariable>>)writtenVariables).contains(field) || (parent = body.getParent()) instanceof PsiMethod && ((PsiMethod)parent).isConstructor() && field.getInitializer() != null && !field.hasModifierProperty("static") && PsiTreeUtil.isAncestor((PsiElement)((PsiMethod)parent).getContainingClass(), (PsiElement)field, (boolean)true)) continue;
                candidates.remove(field);
            }
        }
        catch (AnalysisCanceledException e) {
            candidates.clear();
        }
    }

    private static Collection<PsiVariable> getWrittenVariables(ControlFlow controlFlow, Ref<Collection<PsiVariable>> writtenVariables) {
        if (writtenVariables.get() == null) {
            writtenVariables.set(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        }
        return (Collection)writtenVariables.get();
    }

    private static void removeFieldsReferencedFromInitializers(final PsiClass aClass, final Set<PsiField> candidates) {
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethod(PsiMethod method) {
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiField field;
                PsiElement resolved;
                PsiExpression qualifier = expression.getQualifierExpression();
                if ((qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null) && (resolved = expression.resolve()) instanceof PsiField && aClass.equals((field = (PsiField)resolved).getContainingClass())) {
                    candidates.remove(field);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private static boolean hasImplicitReadOrWriteUsage(PsiField field, ImplicitUsageProvider[] implicitUsageProviders) {
        for (ImplicitUsageProvider provider : implicitUsageProviders) {
            if (!provider.isImplicitRead((PsiElement)field) && !provider.isImplicitWrite((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    public boolean runForWholeFile() {
        return true;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private final PsiField myField;

        public MyQuickFix(PsiField field) {
            this.myField = field;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.field.can.be.local.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$MyQuickFix.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$MyQuickFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$MyQuickFix.applyFix must not be null");
            }
            if (!this.myField.isValid()) {
                return;
            }
            Collection refs = ReferencesSearch.search((PsiElement)this.myField).findAll();
            if (refs.isEmpty()) {
                return;
            }
            HashSet refsSet = new HashSet(refs);
            PsiCodeBlock anchorBlock = MyQuickFix.findAnchorBlock(refs);
            if (anchorBlock == null) {
                return;
            }
            if (!CodeInsightUtil.preparePsiElementsForWrite(new PsiElement[]{anchorBlock})) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            String propertyName = styleManager.variableNameToPropertyName(this.myField.getName(), VariableKind.FIELD);
            String localName = styleManager.propertyNameToVariableName(propertyName, VariableKind.LOCAL_VARIABLE);
            localName = RefactoringUtil.suggestUniqueVariableName(localName, (PsiElement)anchorBlock, this.myField);
            PsiElement firstElement = MyQuickFix.getFirstElement(refs);
            boolean mayBeFinal = MyQuickFix.mayBeFinal((Set<PsiReference>)refsSet, firstElement);
            PsiElement newDeclaration = null;
            try {
                PsiElement anchor = MyQuickFix.getAnchorElement(anchorBlock, firstElement);
                if (anchor instanceof PsiExpressionStatement && ((PsiExpressionStatement)anchor).getExpression() instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression expression = (PsiAssignmentExpression)((PsiExpressionStatement)anchor).getExpression();
                    if (expression.getOperationTokenType() == JavaTokenType.EQ && expression.getLExpression() instanceof PsiReferenceExpression && ((PsiReference)expression.getLExpression()).isReferenceTo((PsiElement)this.myField)) {
                        PsiExpression initializer = expression.getRExpression();
                        PsiDeclarationStatement decl = elementFactory.createVariableDeclarationStatement(localName, this.myField.getType(), initializer);
                        if (!mayBeFinal) {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiModifierListOwner)decl.getDeclaredElements()[0]), (String)"final", (boolean)false);
                        }
                        newDeclaration = anchor.replace((PsiElement)decl);
                        refsSet.remove(expression.getLExpression());
                        MyQuickFix.retargetReferences(elementFactory, localName, (Set<PsiReference>)refsSet);
                    } else {
                        newDeclaration = this.addDeclarationWithFieldInitializerAndRetargetReferences(elementFactory, localName, anchorBlock, anchor, (Set<PsiReference>)refsSet);
                    }
                } else {
                    newDeclaration = this.addDeclarationWithFieldInitializerAndRetargetReferences(elementFactory, localName, anchorBlock, anchor, (Set<PsiReference>)refsSet);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            if (newDeclaration != null) {
                PsiFile file;
                PsiFile psiFile = this.myField.getContainingFile();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor != null && IJSwingUtilities.hasFocus(editor.getComponent()) && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == psiFile) {
                    editor.getCaretModel().moveToOffset(newDeclaration.getTextOffset());
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            }
            try {
                this.myField.normalizeDeclaration();
                this.myField.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static boolean mayBeFinal(Set<PsiReference> refsSet, PsiElement firstElement) {
            for (PsiReference ref : refsSet) {
                PsiElement element = ref.getElement();
                if (element == firstElement || !(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
                return false;
            }
            return true;
        }

        private static void retargetReferences(PsiElementFactory elementFactory, String localName, Set<PsiReference> refs) throws IncorrectOperationException {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)elementFactory.createExpressionFromText(localName, null);
            for (PsiReference ref : refs) {
                if (!(ref instanceof PsiReferenceExpression)) continue;
                ((PsiReferenceExpression)ref).replace((PsiElement)refExpr);
            }
        }

        private PsiElement addDeclarationWithFieldInitializerAndRetargetReferences(PsiElementFactory elementFactory, String localName, PsiCodeBlock anchorBlock, PsiElement anchor, Set<PsiReference> refs) throws IncorrectOperationException {
            PsiDeclarationStatement decl = elementFactory.createVariableDeclarationStatement(localName, this.myField.getType(), this.myField.getInitializer());
            PsiElement newDeclaration = anchorBlock.addBefore((PsiElement)decl, anchor);
            MyQuickFix.retargetReferences(elementFactory, localName, refs);
            return newDeclaration;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$MyQuickFix.getFamilyName must not return null");
            }
            return string;
        }

        private static PsiElement getAnchorElement(PsiCodeBlock anchorBlock, @NotNull PsiElement firstElement) {
            PsiElement element;
            if (firstElement == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspection$MyQuickFix.getAnchorElement must not be null");
            }
            for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
            }
            return element;
        }

        private static PsiElement getFirstElement(Collection<PsiReference> refs) {
            PsiElement firstElement = null;
            for (PsiReference reference : refs) {
                PsiElement element = reference.getElement();
                if (firstElement != null && firstElement.getTextRange().getStartOffset() <= element.getTextRange().getStartOffset()) continue;
                firstElement = element;
            }
            return firstElement;
        }

        private static PsiCodeBlock findAnchorBlock(Collection<PsiReference> refs) {
            PsiCodeBlock result = null;
            for (PsiReference psiReference : refs) {
                PsiElement element = psiReference.getElement();
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
                if (result == null || block == null) {
                    result = block;
                    continue;
                }
                PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)block);
                result = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class, (boolean)false);
            }
            return result;
        }
    }
}

