/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NonFinalFieldInImmutableInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("Concurrency annotation issues" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection.getGroupDisplayName must not return null");
        }
        return "Concurrency annotation issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Non-final field in @Immutable class" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection.getDisplayName must not return null");
        }
        return "Non-final field in @Immutable class";
    }

    @NotNull
    public String getShortName() {
        if ("NonFinalFieldInImmutable" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection.getShortName must not return null");
        }
        return "NonFinalFieldInImmutable";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitField(PsiField field) {
                super.visitField(field);
                if (field.hasModifierProperty("final")) {
                    return;
                }
                PsiClass containingClass = field.getContainingClass();
                if (!JCiPUtil.isImmutable(containingClass)) {
                    return;
                }
                holder.registerProblem((PsiElement)field, "Non-final field #ref in @Immutable class  #loc", new LocalQuickFix[0]);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }
}

