/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddOverrideAnnotationAction
implements IntentionAction {
    private static final String JAVA_LANG_OVERRIDE = "java.lang.Override";

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.add.override.annotation", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.override.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiMethod[] superMethods;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction.isAvailable must not be null");
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file)) {
            return false;
        }
        PsiMethod method = AddOverrideAnnotationAction.findMethod(file, editor.getCaretModel().getOffset());
        if (method == null) {
            return false;
        }
        if (method.getModifierList().findAnnotation(JAVA_LANG_OVERRIDE) != null) {
            return false;
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            if (superMethod.hasModifierProperty("abstract") || !new AddAnnotationFix(JAVA_LANG_OVERRIDE, (PsiModifierListOwner)method, new String[0]).isAvailable(project, editor, file)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AddOverrideAnnotationAction.invoke must not be null");
        }
        PsiMethod method = AddOverrideAnnotationAction.findMethod(file, editor.getCaretModel().getOffset());
        new AddAnnotationFix(JAVA_LANG_OVERRIDE, (PsiModifierListOwner)method, new String[0]).invoke(project, editor, file);
    }

    private static PsiMethod findMethod(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        PsiMethod res = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (res == null) {
            return null;
        }
        PsiCodeBlock body = res.getBody();
        if (body == null) {
            return null;
        }
        if (body.getTextRange().getStartOffset() <= offset) {
            return null;
        }
        return res;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

