/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;

class XmlMover
extends LineMover {
    XmlMover() {
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement updatedElement;
        XmlTag parent;
        PsiElement movedStartElement;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/moveUpDown/XmlMover.checkAvailable must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/moveUpDown/XmlMover.checkAvailable must not be null");
        }
        if (info == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/editorActions/moveUpDown/XmlMover.checkAvailable must not be null");
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        boolean available = super.checkAvailable(editor, file, info, down);
        if (!available) {
            return false;
        }
        Document document = editor.getDocument();
        int movedLineStart = document.getLineStartOffset(info.toMove.startLine);
        int movedLineEnd = document.getLineEndOffset(info.toMove.endLine - 1);
        PsiElement movedEndElement = file.findElementAt(movedLineEnd);
        if (movedEndElement instanceof PsiWhiteSpace) {
            movedEndElement = PsiTreeUtil.prevLeaf((PsiElement)movedEndElement);
        }
        if ((movedStartElement = file.findElementAt(movedLineStart)) instanceof PsiWhiteSpace) {
            movedStartElement = PsiTreeUtil.nextLeaf((PsiElement)movedStartElement);
        }
        if (movedEndElement == null || movedStartElement == null) {
            return false;
        }
        PsiNamedElement namedParentAtEnd = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)movedEndElement, PsiNamedElement.class);
        PsiNamedElement namedParentAtStart = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)movedStartElement, PsiNamedElement.class);
        XmlText text = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)movedStartElement, XmlText.class);
        XmlText text2 = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)movedEndElement, XmlText.class);
        if (text != null && ((PsiLanguageInjectionHost)text).getInjectedPsi() != null || text2 != null && ((PsiLanguageInjectionHost)text2).getInjectedPsi() != null) {
            return false;
        }
        XmlTag nearestTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)movedStartElement, XmlTag.class);
        if (nearestTag != null && ("script".equals(nearestTag.getLocalName()) || nearestTag instanceof HtmlTag && "script".equalsIgnoreCase(nearestTag.getLocalName()))) {
            return false;
        }
        PsiNamedElement movedParent = null;
        if (namedParentAtEnd == namedParentAtStart) {
            movedParent = namedParentAtEnd;
        } else if (namedParentAtEnd instanceof XmlAttribute && namedParentAtStart instanceof XmlTag && namedParentAtEnd.getParent() == namedParentAtStart) {
            movedParent = namedParentAtStart;
        } else if (namedParentAtStart instanceof XmlAttribute && namedParentAtEnd instanceof XmlTag && namedParentAtStart.getParent() == namedParentAtEnd) {
            movedParent = namedParentAtEnd;
        }
        if (movedParent == null) {
            return false;
        }
        TextRange textRange = movedParent.getTextRange();
        if (movedParent instanceof XmlTag) {
            XmlTag tag = (XmlTag)movedParent;
            TextRange valueRange = tag.getValue().getTextRange();
            int valueStart = valueRange.getStartOffset();
            if (movedLineStart < valueStart && valueStart + 1 < document.getTextLength()) {
                movedLineStart = this.updateMovedRegionEnd(document, movedLineStart, valueStart + 1, info, down);
            }
            if (movedLineStart < valueStart) {
                movedLineStart = this.updatedMovedRegionStart(document, movedLineStart, tag.getTextRange().getStartOffset(), info, down);
            }
        } else if (movedParent instanceof XmlAttribute) {
            int endOffset = textRange.getEndOffset() + 1;
            if (endOffset < document.getTextLength()) {
                movedLineStart = this.updateMovedRegionEnd(document, movedLineStart, endOffset, info, down);
            }
            movedLineStart = this.updatedMovedRegionStart(document, movedLineStart, textRange.getStartOffset(), info, down);
        } else if (!movedParent.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            return false;
        }
        TextRange moveDestinationRange = new TextRange(document.getLineStartOffset(info.toMove2.startLine), document.getLineStartOffset(info.toMove2.endLine));
        if (movedParent instanceof XmlAttribute && (parent = ((XmlAttribute)movedParent).getParent()) != null) {
            TextRange valueRange = parent.getValue().getTextRange();
            if (down && moveDestinationRange.getEndOffset() >= valueRange.getStartOffset() || !down && moveDestinationRange.getStartOffset() <= parent.getTextRange().getStartOffset()) {
                info.toMove2 = null;
            }
        }
        if (down) {
            updatedElement = file.findElementAt(moveDestinationRange.getEndOffset());
            if (updatedElement instanceof PsiWhiteSpace) {
                updatedElement = PsiTreeUtil.prevLeaf((PsiElement)updatedElement);
            }
            if (updatedElement != null) {
                PsiNamedElement namedParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)updatedElement, movedParent.getClass());
                if (namedParent instanceof XmlTag) {
                    XmlTag tag = (XmlTag)namedParent;
                    int offset = tag.isEmpty() ? tag.getTextRange().getStartOffset() : tag.getValue().getTextRange().getStartOffset();
                    this.updatedMovedIntoEnd(document, info, offset);
                } else if (namedParent instanceof XmlAttribute) {
                    this.updatedMovedIntoEnd(document, info, namedParent.getTextRange().getEndOffset());
                }
            }
        } else {
            updatedElement = file.findElementAt(moveDestinationRange.getStartOffset());
            if (updatedElement instanceof PsiWhiteSpace) {
                updatedElement = PsiTreeUtil.nextLeaf((PsiElement)updatedElement);
            }
            if (updatedElement != null) {
                PsiNamedElement namedParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)updatedElement, movedParent.getClass());
                if (namedParent instanceof XmlTag) {
                    XmlTag tag = (XmlTag)namedParent;
                    TextRange tagValueRange = tag.getValue().getTextRange();
                    XmlTag[] subtags = tag.getSubTags();
                    if (tagValueRange.contains(movedLineStart) && subtags.length > 0 && subtags[0] == movedParent || tagValueRange.getLength() == 0 && tag.getTextRange().intersects(moveDestinationRange)) {
                        int line = document.getLineNumber(tag.getTextRange().getStartOffset());
                        LineRange toMove2 = info.toMove2;
                        info.toMove2 = new LineRange(Math.min(line, toMove2.startLine), toMove2.endLine);
                    }
                } else if (namedParent instanceof XmlAttribute) {
                    int line = document.getLineNumber(namedParent.getTextRange().getStartOffset());
                    LineRange toMove2 = info.toMove2;
                    info.toMove2 = new LineRange(Math.min(line, toMove2.startLine), toMove2.endLine);
                }
            }
        }
        return true;
    }

    private void updatedMovedIntoEnd(Document document, @NotNull StatementUpDownMover.MoveInfo info, int offset) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/moveUpDown/XmlMover.updatedMovedIntoEnd must not be null");
        }
        if (offset + 1 < document.getTextLength()) {
            int line = document.getLineNumber(offset + 1);
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine, Math.min(Math.max(line, toMove2.endLine), document.getLineCount() - 1));
        }
    }

    private int updatedMovedRegionStart(Document document, int movedLineStart, int offset, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/editorActions/moveUpDown/XmlMover.updatedMovedRegionStart must not be null");
        }
        int line = document.getLineNumber(offset);
        LineRange toMove = info.toMove;
        int delta = toMove.startLine - line;
        info.toMove = new LineRange(Math.min(line, toMove.startLine), toMove.endLine);
        if (delta > 0 && !down) {
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine - delta, toMove2.endLine - delta);
            movedLineStart = document.getLineStartOffset(toMove.startLine);
        }
        return movedLineStart;
    }

    private int updateMovedRegionEnd(Document document, int movedLineStart, int valueStart, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/editorActions/moveUpDown/XmlMover.updateMovedRegionEnd must not be null");
        }
        int line = document.getLineNumber(valueStart);
        LineRange toMove = info.toMove;
        int delta = line - toMove.endLine;
        info.toMove = new LineRange(toMove.startLine, Math.max(line, toMove.endLine));
        if (delta > 0 && down) {
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine + delta, Math.min(toMove2.endLine + delta, document.getLineCount() - 1));
            movedLineStart = document.getLineStartOffset(toMove.startLine);
        }
        return movedLineStart;
    }
}

