/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;

public class CutHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public CutHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        if (project == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection() && !selectionModel.hasBlockSelection()) {
            selectionModel.selectLineAtCaret();
            if (!selectionModel.hasSelection()) {
                return;
            }
        }
        EditorActionManager.getInstance().getActionHandler("EditorCopy").execute(editor, dataContext);
        EditorModificationUtil.deleteSelectedText((Editor)editor);
    }
}

