/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ReuseVariableDeclarationFix
implements IntentionAction {
    private final PsiVariable variable;
    private final PsiIdentifier identifier;

    public ReuseVariableDeclarationFix(PsiVariable variable, PsiIdentifier identifier) {
        this.variable = variable;
        this.identifier = identifier;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("reuse.variable.declaration.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("reuse.variable.declaration.text", this.variable.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix.isAvailable must not be null");
        }
        PsiVariable previousVariable = this.findPreviousVariable();
        return this.variable != null && this.variable.isValid() && this.variable instanceof PsiLocalVariable && previousVariable != null && Comparing.equal((Object)previousVariable.getType(), (Object)this.variable.getType()) && this.identifier != null && this.identifier.isValid() && this.variable.getManager().isInProject((PsiElement)this.variable);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix.invoke must not be null");
        }
        PsiVariable refVariable = this.findPreviousVariable();
        if (refVariable == null) {
            return;
        }
        if (!CodeInsightUtil.preparePsiElementsForWrite(new PsiElement[]{this.variable, refVariable})) {
            return;
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)refVariable, (String)"final", (boolean)false);
        if (this.variable.getInitializer() == null) {
            this.variable.delete();
            return;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)this.variable.getParent();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.variable.getProject()).getElementFactory();
        PsiStatement statement = factory.createStatementFromText(this.variable.getName() + " = " + this.variable.getInitializer().getText() + ";", (PsiElement)this.variable);
        declaration.replace((PsiElement)statement);
    }

    private PsiVariable findPreviousVariable() {
        PsiElement scope;
        for (scope = this.variable.getParent(); !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return null;
        }
        VariablesNotProcessor proc = new VariablesNotProcessor(this.variable, false);
        PsiScopesUtil.treeWalkUp(proc, (PsiElement)this.identifier, scope);
        if (proc.size() > 0) {
            return proc.getResult(0);
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

