/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermuteArgumentsFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix");
    private final PsiCall myCall;
    private final PsiCall myPermutation;

    private PermuteArgumentsFix(@NotNull PsiCall call, @NotNull PsiCall permutation) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix.<init> must not be null");
        }
        if (permutation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix.<init> must not be null");
        }
        this.myCall = call;
        this.myPermutation = permutation;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("permute.arguments", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix.isAvailable must not be null");
        }
        return !project.isDisposed() && this.myCall.isValid() && this.myCall.getManager().isInProject((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        this.myCall.getArgumentList().replace((PsiElement)this.myPermutation.getArgumentList());
    }

    public static void registerFix(HighlightInfo info, PsiCall callExpression, CandidateInfo[] candidates, TextRange fixRange) {
        PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
        if (expressions.length < 2) {
            return;
        }
        ArrayList<PsiCall> permutations = new ArrayList<PsiCall>();
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            MethodCandidateInfo methodCandidate = (MethodCandidateInfo)candidate;
            PsiMethod method = methodCandidate.getElement();
            PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (expressions.length != parameters.length || parameters.length == 0) continue;
            int minIncompatibleIndex = parameters.length;
            int maxIncompatibleIndex = 0;
            int incompatibilitiesCount = 0;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType type = substitutor.substitute(parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type, (PsiExpression)expressions[i])) continue;
                if (minIncompatibleIndex == parameters.length) {
                    minIncompatibleIndex = i;
                }
                maxIncompatibleIndex = i;
                ++incompatibilitiesCount;
            }
            try {
                PermuteArgumentsFix.registerSwapFixes(expressions, callExpression, permutations, methodCandidate, incompatibilitiesCount, minIncompatibleIndex, maxIncompatibleIndex);
                PermuteArgumentsFix.registerShiftFixes(expressions, callExpression, permutations, methodCandidate, minIncompatibleIndex, maxIncompatibleIndex);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (permutations.size() == 1) {
            PermuteArgumentsFix fix = new PermuteArgumentsFix(callExpression, (PsiCall)permutations.get(0));
            QuickFixAction.registerQuickFixAction(info, fixRange, fix, null);
        }
    }

    private static void registerShiftFixes(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, MethodCandidateInfo methodCandidate, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = methodCandidate.getElement();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        for (int i = 0; i <= minIncompatibleIndex; ++i) {
            for (int j = Math.max(i + 2, maxIncompatibleIndex); j < expressions.length; ++j) {
                JavaResolveResult result;
                PsiExpression[] copyExpressions;
                PsiCall copy;
                ArrayUtil.rotateLeft((Object[])expressions, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    copy = (PsiCall)callExpression.copy();
                    copyExpressions = copy.getArgumentList().getExpressions();
                    for (int k = i; k < copyExpressions.length; ++k) {
                        copyExpressions[k].replace((PsiElement)expressions[k]);
                    }
                    result = copy.resolveMethodGenerics();
                    if (result.getElement() != null && result.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.rotateRight((Object[])expressions, (int)i, (int)j);
                ArrayUtil.rotateRight((Object[])expressions, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    copy = (PsiCall)callExpression.copy();
                    copyExpressions = copy.getArgumentList().getExpressions();
                    for (int k = i; k < copyExpressions.length; ++k) {
                        copyExpressions[k].replace((PsiElement)expressions[k]);
                    }
                    result = copy.resolveMethodGenerics();
                    if (result.getElement() != null && result.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.rotateLeft((Object[])expressions, (int)i, (int)j);
            }
        }
    }

    private static void registerSwapFixes(PsiExpression[] expressions, PsiCall callExpression, List<PsiCall> permutations, MethodCandidateInfo candidate, int incompatibilitiesCount, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (incompatibilitiesCount >= 3) {
            return;
        }
        for (int i = minIncompatibleIndex; i < maxIncompatibleIndex; ++i) {
            for (int j = i + 1; j <= maxIncompatibleIndex; ++j) {
                ArrayUtil.swap((Object[])expressions, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    PsiCall copy = (PsiCall)callExpression.copy();
                    PsiExpression[] copyExpressions = copy.getArgumentList().getExpressions();
                    copyExpressions[i].replace((PsiElement)expressions[i]);
                    copyExpressions[j].replace((PsiElement)expressions[j]);
                    JavaResolveResult result = copy.resolveMethodGenerics();
                    if (result.getElement() != null && result.isValidResult()) {
                        permutations.add(copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.swap((Object[])expressions, (int)i, (int)j);
            }
        }
    }
}

