/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertReturnStatementsVisitor;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnBooleanFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnBooleanFix");
    private final PsiMethod myMethod;
    private final PsiType myReturnType;

    public MethodReturnBooleanFix(PsiMethod method, PsiType returnType) {
        this.myMethod = method;
        this.myReturnType = returnType;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.return.type.text", this.myMethod.getName(), this.myReturnType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.return.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix.isAvailable must not be null");
        }
        return this.myMethod != null && this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myReturnType != null && this.myReturnType.isValid() && !TypeConversionUtil.isNullType((PsiType)this.myReturnType) && this.myMethod.getReturnType() != null && !Comparing.equal((Object)this.myReturnType, (Object)this.myMethod.getReturnType());
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        List<PsiMethod> affectedMethods = MethodReturnBooleanFix.changeReturnType(this.myMethod, this.myReturnType);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        SourceMethodSelector returnSelector = new SourceMethodSelector(this.myMethod);
        ReturnStatementAdder adder = new ReturnStatementAdder(factory, this.myReturnType, returnSelector);
        for (PsiMethod method : affectedMethods) {
            adder.addReturnForMethod(file, method);
        }
        PsiReturnStatement latestReturn = returnSelector.getReturnStatement();
        if (latestReturn != null) {
            MethodReturnBooleanFix.selectReturnValueInEditor(latestReturn, this.getEditorForMethod(project, editor, latestReturn.getContainingFile()));
        }
    }

    private Editor getEditorForMethod(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix.getEditorForMethod must not be null");
        }
        if (this.myMethod.getContainingFile() != file) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.myMethod.getContainingFile().getVirtualFile());
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        return editor;
    }

    @Nullable
    private static PsiMethod[] getChangeRoots(PsiMethod method) {
        PsiMethod[] methods = method.findDeepestSuperMethods();
        if (methods.length > 0) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return methods;
            }
            String methodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)7);
            int result = Messages.showYesNoCancelDialog((String)QuickFixBundle.message("quickfix.retun.type.void.to.boolean.inherited.warning.text", method.getContainingClass().getName() + "." + methodName), (String)QuickFixBundle.message("quickfix.retun.type.void.to.boolean.inherited.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (2 == result) {
                return null;
            }
            if (0 == result) {
                return methods;
            }
        }
        return new PsiMethod[]{method};
    }

    private static List<PsiMethod> changeReturnType(PsiMethod method, PsiType returnType) {
        PsiMethod[] methods = MethodReturnBooleanFix.getChangeRoots(method);
        if (methods == null) {
            return Collections.emptyList();
        }
        MethodSignatureChangeVisitor methodSignatureChangeVisitor = new MethodSignatureChangeVisitor();
        for (PsiMethod targetMethod : methods) {
            methodSignatureChangeVisitor.addBase(targetMethod);
            UsagesAwareChangeSignatureProcessor processor = new UsagesAwareChangeSignatureProcessor(method.getProject(), targetMethod, false, null, method.getName(), returnType, RemoveUnusedParameterFix.getNewParametersInfo(method, null), methodSignatureChangeVisitor);
            processor.run();
        }
        return methodSignatureChangeVisitor.getAffectedMethods();
    }

    private static void selectReturnValueInEditor(PsiReturnStatement returnStatement, Editor editor) {
        TextRange range = returnStatement.getReturnValue().getTextRange();
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().setSelection(range.getEndOffset(), range.getStartOffset());
    }

    private static class UsagesAwareChangeSignatureProcessor
    extends ChangeSignatureProcessor {
        private final UsageVisitor myUsageVisitor;

        private UsagesAwareChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @Modifier String newVisibility, String newName, PsiType newType, @NotNull ParameterInfoImpl[] parameterInfo, UsageVisitor usageVisitor) {
            if (parameterInfo == null) {
                throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix$UsagesAwareChangeSignatureProcessor.<init> must not be null");
            }
            super(project, method, generateDelegate, newVisibility, newName, newType, parameterInfo);
            this.myUsageVisitor = usageVisitor;
        }

        @Override
        protected void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            this.myUsageVisitor.preprocessCovariantOverriders(covariantOverriderInfos);
        }

        @Override
        protected void performRefactoring(UsageInfo[] usages) {
            super.performRefactoring(usages);
            for (UsageInfo usage : usages) {
                this.myUsageVisitor.visit(usage);
            }
        }
    }

    private static interface UsageVisitor {
        public void visit(UsageInfo var1);

        public void preprocessCovariantOverriders(List<UsageInfo> var1);
    }

    private static class MethodSignatureChangeVisitor
    implements UsageVisitor {
        private final List<PsiMethod> myAffectedMethods = new ArrayList<PsiMethod>();

        private MethodSignatureChangeVisitor() {
        }

        public void addBase(PsiMethod baseMethod) {
            this.myAffectedMethods.add(baseMethod);
        }

        @Override
        public void visit(UsageInfo usage) {
            if (usage instanceof OverriderUsageInfo) {
                this.myAffectedMethods.add(((OverriderUsageInfo)usage).getElement());
            }
        }

        public List<PsiMethod> getAffectedMethods() {
            return this.myAffectedMethods;
        }

        @Override
        public void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            Iterator<UsageInfo> usageInfoIterator = covariantOverriderInfos.iterator();
            while (usageInfoIterator.hasNext()) {
                OverriderUsageInfo overrideUsage;
                UsageInfo info = usageInfoIterator.next();
                if (!(info instanceof OverriderUsageInfo) || !this.myAffectedMethods.contains((overrideUsage = (OverriderUsageInfo)info).getElement())) continue;
                usageInfoIterator.remove();
            }
        }
    }

    private static class ReturnStatementAdder {
        private final PsiElementFactory factory;
        private final PsiType myTargetType;
        private final GeneratedReturnSelector mySelector;

        private ReturnStatementAdder(@NotNull PsiElementFactory factory, @NotNull PsiType targetType, @NotNull GeneratedReturnSelector selector) {
            if (factory == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix$ReturnStatementAdder.<init> must not be null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix$ReturnStatementAdder.<init> must not be null");
            }
            if (selector == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnBooleanFix$ReturnStatementAdder.<init> must not be null");
            }
            this.factory = factory;
            this.myTargetType = targetType;
            this.mySelector = selector;
        }

        public void addReturnForMethod(PsiFile file, PsiMethod method) {
            PsiModifierList modifiers = method.getModifierList();
            if (modifiers.hasModifierProperty("abstract") || method.getBody() == null) {
                return;
            }
            try {
                ConvertReturnStatementsVisitor visitor = new ConvertReturnStatementsVisitor(this.factory, method, this.myTargetType);
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)method.getBody());
                if (ControlFlowUtil.checkReturns(controlFlow, visitor)) {
                    this.mySelector.accept(visitor.getLatestReturn(), method);
                    return;
                }
                this.mySelector.accept(visitor.createReturnInLastStatement(), method);
            }
            catch (AnalysisCanceledException e) {
                LOG.error((Throwable)e);
                return;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            if (method.getContainingFile() != file) {
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        }
    }

    private static interface GeneratedReturnSelector {
        public void accept(PsiReturnStatement var1, PsiMethod var2);
    }

    private static class SourceMethodSelector
    implements GeneratedReturnSelector {
        private final PsiMethod mySourceMethod;
        private PsiReturnStatement myReturnStatement;

        private SourceMethodSelector(PsiMethod sourceMethod) {
            this.mySourceMethod = sourceMethod;
        }

        @Override
        public void accept(PsiReturnStatement statement, PsiMethod method) {
            if (this.mySourceMethod.equals(method) && statement != null) {
                this.myReturnStatement = statement;
            }
        }

        public PsiReturnStatement getReturnStatement() {
            return this.myReturnStatement;
        }
    }
}

