/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.OptionsDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LayoutCodeDialog
extends DialogWrapper {
    private final PsiFile myFile;
    @Nullable
    private final PsiDirectory myDirectory;
    private final Boolean myTextSelected;
    private JRadioButton myRbFile;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbDirectory;
    private JCheckBox myCbIncludeSubdirs;
    private JCheckBox myCbOptimizeImports;
    private JCheckBox myDoNotAskMeCheckBox;
    @NonNls
    public static final String OPTIMIZE_IMPORTS_KEY = "LayoutCode.optimizeImports";
    private final String myHelpId;

    public LayoutCodeDialog(Project project, String title, PsiFile file, @Nullable PsiDirectory directory, Boolean isTextSelected, String helpId) {
        super(project, true);
        this.myFile = file;
        this.myDirectory = directory;
        this.myTextSelected = isTextSelected;
        this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
        this.setTitle(title);
        this.init();
        this.myHelpId = helpId;
    }

    protected void init() {
        super.init();
        if (this.myTextSelected == Boolean.TRUE) {
            this.myRbSelectedText.setSelected(true);
        } else if (this.myFile != null) {
            this.myRbFile.setSelected(true);
        } else {
            this.myRbDirectory.setSelected(true);
        }
        this.myCbIncludeSubdirs.setSelected(true);
        this.myCbOptimizeImports.setSelected(LayoutCodeDialog.isOptmizeImportsOptionOn());
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LayoutCodeDialog.this.updateState();
            }
        };
        this.myRbFile.addItemListener(listener);
        this.myRbSelectedText.addItemListener(listener);
        this.myRbDirectory.addItemListener(listener);
        this.myCbIncludeSubdirs.addItemListener(listener);
        this.updateState();
    }

    private static boolean isOptmizeImportsOptionOn() {
        return Boolean.toString(true).equals(PropertiesComponent.getInstance().getValue(OPTIMIZE_IMPORTS_KEY));
    }

    private static void setOptimizeImportsOption(boolean state) {
        PropertiesComponent.getInstance().setValue(OPTIMIZE_IMPORTS_KEY, Boolean.toString(state));
    }

    private void updateState() {
        this.myCbIncludeSubdirs.setEnabled(this.myRbDirectory.isSelected());
        this.myCbOptimizeImports.setEnabled(!this.myRbSelectedText.isSelected() && (this.myFile == null || LanguageImportStatements.INSTANCE.forFile(this.myFile) != null || !this.myRbFile.isSelected()));
        this.myDoNotAskMeCheckBox.setEnabled(!this.myRbDirectory.isSelected());
        this.myRbDirectory.setEnabled(!this.myDoNotAskMeCheckBox.isSelected());
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 3;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.myRbFile = new JRadioButton(CodeInsightBundle.message((String)"process.scope.file", (Object[])new Object[]{this.myFile != null ? "'" + this.myFile.getVirtualFile().getPresentableUrl() + "'" : ""}));
        panel.add((Component)this.myRbFile, gbConstraints);
        this.myRbSelectedText = new JRadioButton(CodeInsightBundle.message((String)"reformat.option.selected.text", (Object[])new Object[0]));
        if (this.myTextSelected != null) {
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myRbSelectedText, gbConstraints);
        }
        this.myRbDirectory = new JRadioButton();
        this.myCbIncludeSubdirs = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.include.subdirectories", (Object[])new Object[0]));
        if (this.myDirectory != null) {
            this.myRbDirectory.setText(CodeInsightBundle.message((String)"reformat.option.all.files.in.directory", (Object[])new Object[]{this.myDirectory.getVirtualFile().getPresentableUrl()}));
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myRbDirectory, gbConstraints);
            if (this.myDirectory.getSubdirectories().length > 0) {
                ++gbConstraints.gridy;
                gbConstraints.insets = new Insets(0, 20, 0, 0);
                panel.add((Component)this.myCbIncludeSubdirs, gbConstraints);
            }
        }
        this.myCbOptimizeImports = new JCheckBox(CodeInsightBundle.message((String)"reformat.option.optimize.imports", (Object[])new Object[0]));
        if (this.myTextSelected != null && LanguageImportStatements.INSTANCE.hasAnyExtensions()) {
            ++gbConstraints.gridy;
            gbConstraints.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)this.myCbOptimizeImports, gbConstraints);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbFile);
        buttonGroup.add(this.myRbSelectedText);
        buttonGroup.add(this.myRbDirectory);
        this.myRbFile.setEnabled(this.myFile != null);
        this.myRbSelectedText.setEnabled(this.myTextSelected == Boolean.TRUE);
        return panel;
    }

    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        this.myDoNotAskMeCheckBox = new JCheckBox(CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]));
        this.myDoNotAskMeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutCodeDialog.this.updateState();
            }
        });
        return OptionsDialog.addDoNotShowCheckBox((JComponent)southPanel, (JCheckBox)this.myDoNotAskMeCheckBox);
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpId);
    }

    public boolean isProcessSelectedText() {
        return this.myRbSelectedText.isSelected();
    }

    public boolean isProcessDirectory() {
        return this.myRbDirectory.isSelected();
    }

    public boolean isIncludeSubdirectories() {
        return this.myCbIncludeSubdirs.isSelected();
    }

    public boolean isOptimizeImports() {
        return this.myCbOptimizeImports.isSelected();
    }

    boolean isDoNotAskMe() {
        return this.myDoNotAskMeCheckBox.isSelected();
    }

    protected void doOKAction() {
        super.doOKAction();
        LayoutCodeDialog.setOptimizeImportsOption(this.isOptimizeImports());
    }
}

