/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.SurroundAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;

public class NoScrollPaneInspection
extends BaseFormInspection {
    public NoScrollPaneInspection() {
        super("NoScrollPane");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.no.scroll.pane", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/inspections/NoScrollPaneInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected void checkComponentProperties(Module module, IComponent component, FormErrorCollector collector) {
        if (FormInspectionUtil.isComponentClass(module, component, Scrollable.class) && !FormInspectionUtil.isComponentClass(module, component, JTextField.class) && !FormInspectionUtil.isComponentClass(module, (IComponent)component.getParentContainer(), JScrollPane.class)) {
            collector.addError(this.getID(), component, null, UIDesignerBundle.message("inspection.no.scroll.pane", new Object[0]), new EditorQuickFixProvider(){

                @Override
                public QuickFix createQuickFix(GuiEditor editor, RadComponent component) {
                    return new MyQuickFix(editor, component);
                }
            });
        }
    }

    private static class MyQuickFix
    extends QuickFix {
        public MyQuickFix(GuiEditor editor, RadComponent component) {
            super(editor, UIDesignerBundle.message("inspection.no.scroll.pane.quickfix", new Object[0]), component);
        }

        @Override
        public void run() {
            ArrayList<RadComponent> targetList = new ArrayList<RadComponent>(Collections.singletonList(this.myComponent));
            new SurroundAction(JScrollPane.class.getName()).actionPerformed(this.myEditor, targetList, null);
        }
    }
}

