/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class EmptyTextHelper {
    private static final int EMPTY_TEXT_TOP = 20;
    private final JComponent myOwner;
    private String myEmptyText = "";
    private final SimpleColoredComponent myEmptyTextComponent = new SimpleColoredComponent();
    private final ArrayList<ActionListener> myEmptyTextClickListeners = new ArrayList();

    public EmptyTextHelper(JComponent owner) {
        this.myOwner = owner;
        this.myOwner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ActionListener actionListener;
                if (e.getButton() == 1 && e.getClickCount() == 1 && EmptyTextHelper.this.isEmpty() && (actionListener = EmptyTextHelper.this.findEmptyTextActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent(this, 0, ""));
                }
            }
        });
        this.myOwner.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (EmptyTextHelper.this.isEmpty()) {
                    if (EmptyTextHelper.this.findEmptyTextActionListenerAt(e.getPoint()) != null) {
                        EmptyTextHelper.this.myOwner.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        EmptyTextHelper.this.myOwner.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.myEmptyTextComponent.setFont(UIUtil.getLabelFont());
    }

    @Nullable
    private ActionListener findEmptyTextActionListenerAt(Point point) {
        int index;
        Rectangle bounds = this.myOwner.getBounds();
        Dimension size = this.myEmptyTextComponent.getPreferredSize();
        int x = (bounds.width - size.width) / 2;
        if (new Rectangle(x, 20, bounds.width, bounds.height).contains(point) && (index = this.myEmptyTextComponent.findFragmentAt(point.x - x)) >= 0 && index < this.myEmptyTextClickListeners.size()) {
            return this.myEmptyTextClickListeners.get(index);
        }
        return null;
    }

    public String getEmptyText() {
        return this.myEmptyText;
    }

    public void setEmptyText(String emptyText) {
        this.clearEmptyText();
        this.appendEmptyText(emptyText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public void clearEmptyText() {
        this.myEmptyTextComponent.clear();
        this.myEmptyTextClickListeners.clear();
        this.myEmptyText = "";
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs) {
        this.appendEmptyText(text, attrs, null);
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        this.myEmptyText = this.myEmptyText + text;
        this.myEmptyTextComponent.append(text, attrs);
        this.myEmptyTextClickListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.isEmpty() && this.myEmptyText.length() > 0) {
            this.myEmptyTextComponent.setFont(this.myOwner.getFont());
            this.myEmptyTextComponent.setBackground(this.myOwner.getBackground());
            this.myEmptyTextComponent.setForeground(this.myOwner.getForeground());
            Rectangle bounds = this.myOwner.getBounds();
            Dimension size = this.myEmptyTextComponent.getPreferredSize();
            this.myEmptyTextComponent.setBounds(0, 0, size.width, size.height);
            int x = (bounds.width - size.width) / 2;
            Graphics g2 = g.create(bounds.x + x, bounds.y + 20, size.width, size.height);
            try {
                this.myEmptyTextComponent.paint(g2);
            }
            finally {
                g2.dispose();
            }
        }
    }

    protected abstract boolean isEmpty();
}

