/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.SearchInBackgroundOption;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewManagerImpl
extends UsageViewManager {
    private final Project myProject;
    private static final Key<UsageView> USAGE_VIEW_KEY = Key.create((String)"USAGE_VIEW");
    private volatile boolean mySearchHasBeenCancelled;

    public UsageViewManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public UsageView createUsageView(@NotNull UsageTarget[] targets, @NotNull Usage[] usages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> usageSearcherFactory) {
        if (targets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.createUsageView must not be null");
        }
        if (usages == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.createUsageView must not be null");
        }
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.createUsageView must not be null");
        }
        UsageViewImpl usageView = new UsageViewImpl(this.myProject, presentation, targets, usageSearcherFactory);
        UsageViewManagerImpl.appendUsages(usages, usageView);
        usageView.setSearchInProgress(false);
        UsageViewImpl usageViewImpl = usageView;
        if (usageViewImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewManagerImpl.createUsageView must not return null");
        }
        return usageViewImpl;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> factory) {
        if (searchedFor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not be null");
        }
        if (foundUsages == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not be null");
        }
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not be null");
        }
        UsageView usageView = this.createUsageView(searchedFor, foundUsages, presentation, factory);
        this.addContent((UsageViewImpl)usageView, presentation);
        this.showToolWindow(true);
        UsageView usageView2 = usageView;
        if (usageView2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not return null");
        }
        return usageView2;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation) {
        if (searchedFor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not be null");
        }
        if (foundUsages == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not be null");
        }
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not be null");
        }
        UsageView usageView = this.showUsages(searchedFor, foundUsages, presentation, null);
        if (usageView == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/impl/UsageViewManagerImpl.showUsages must not return null");
        }
        return usageView;
    }

    private void addContent(UsageViewImpl usageView, UsageViewPresentation presentation) {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).addContent(presentation.getTabText(), presentation.getTabName(), presentation.getToolwindowTitle(), true, usageView.getComponent(), presentation.isOpenInNewTab(), true);
        usageView.setContent(content);
        content.putUserData(USAGE_VIEW_KEY, usageView);
    }

    @Override
    public UsageView searchAndShowUsages(final @NotNull UsageTarget[] searchFor, final Factory<UsageSearcher> searcherFactory, boolean showPanelIfOnlyOneUsage, boolean showNotFoundMessage, final @NotNull UsageViewPresentation presentation, final UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.searchAndShowUsages must not be null");
        }
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.searchAndShowUsages must not be null");
        }
        final AtomicReference usageView = new AtomicReference();
        final FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation();
        processPresentation.setShowNotFoundMessage(showNotFoundMessage);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, UsageViewManagerImpl.getProgressTitle(presentation), true, new SearchInBackgroundOption()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl$1.run must not be null");
                }
                new SearchForUsagesRunnable(usageView, presentation, searchFor, searcherFactory, processPresentation, listener).run();
            }

            @Override
            public DumbModeAction getDumbModeAction() {
                return DumbModeAction.CANCEL;
            }

            @Override
            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                String notification = usageView.get() != null ? ((UsageViewImpl)usageView.get()).getUsagesCount() + " Usage(s) Found" : "No Usages Found";
                return new Task.NotificationInfo("Find Usages", "Find Usages Finished", notification);
            }
        };
        ProgressManager.getInstance().run(task);
        return (UsageView)usageView.get();
    }

    @Override
    public void searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull UsageViewPresentation presentation, UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.searchAndShowUsages must not be null");
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.searchAndShowUsages must not be null");
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.searchAndShowUsages must not be null");
        }
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.searchAndShowUsages must not be null");
        }
        AtomicReference usageView = new AtomicReference();
        final SearchForUsagesRunnable runnable = new SearchForUsagesRunnable(usageView, presentation, searchFor, searcherFactory, processPresentation, listener);
        Factory<ProgressIndicator> progressIndicatorFactory = processPresentation.getProgressIndicatorFactory();
        final ProgressIndicator progressIndicator = progressIndicatorFactory != null ? (ProgressIndicator)progressIndicatorFactory.create() : null;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            runnable.searchUsages();
                        }
                    }, progressIndicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        runnable.endSearchForUsages();
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    @Override
    public UsageView getSelectedUsageView() {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).getSelectedContent();
        if (content != null) {
            return (UsageView)content.getUserData(USAGE_VIEW_KEY);
        }
        return null;
    }

    public static String getProgressTitle(UsageViewPresentation presentation) {
        String scopeText = presentation.getScopeText();
        if (scopeText == null) {
            return UsageViewBundle.message("progress.searching.for", StringUtil.capitalize((String)presentation.getUsagesString()));
        }
        return UsageViewBundle.message("progress.searching.for.in", StringUtil.capitalize((String)presentation.getUsagesString()), scopeText);
    }

    private void showToolWindow(boolean activateWindow) {
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(ToolWindowId.FIND);
        toolWindow.show(null);
        if (activateWindow && !toolWindow.isActive()) {
            toolWindow.activate(null);
        }
    }

    private static void appendUsages(final @NotNull Usage[] foundUsages, final UsageViewImpl usageView) {
        if (foundUsages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl.appendUsages must not be null");
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Usage foundUsage : foundUsages) {
                    usageView.appendUsage(foundUsage);
                }
            }
        });
    }

    @Override
    public synchronized void setCurrentSearchCancelled(boolean flag) {
        this.mySearchHasBeenCancelled = flag;
    }

    @Override
    public synchronized boolean searchHasBeenCancelled() {
        return this.mySearchHasBeenCancelled;
    }

    @Override
    public void checkSearchCanceled() throws ProcessCanceledException {
        if (this.searchHasBeenCancelled()) {
            throw new ProcessCanceledException();
        }
        ProgressManager.checkCanceled();
    }

    private static void flashUsageScriptaculously(Usage usage) {
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        rangeBlinker.resetMarkers(usageInfo.getRangeMarkers());
        rangeBlinker.startBlinking();
    }

    private class SearchForUsagesRunnable
    implements Runnable {
        private final AtomicInteger myUsageCountWithoutDefinition;
        private final AtomicReference<Usage> myFirstUsage;
        private final AtomicReference<UsageViewImpl> myUsageViewRef;
        private final UsageViewPresentation myPresentation;
        private final UsageTarget[] mySearchFor;
        private final Factory<UsageSearcher> mySearcherFactory;
        private final FindUsagesProcessPresentation myProcessPresentation;
        private final UsageViewManager.UsageViewStateListener myListener;

        private SearchForUsagesRunnable(@NotNull AtomicReference<UsageViewImpl> usageView, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, FindUsagesProcessPresentation processPresentation, UsageViewManager.UsageViewStateListener listener) {
            if (usageView == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable.<init> must not be null");
            }
            if (presentation == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable.<init> must not be null");
            }
            if (searchFor == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable.<init> must not be null");
            }
            if (searcherFactory == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable.<init> must not be null");
            }
            if (processPresentation == null) {
                throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/usages/impl/UsageViewManagerImpl$SearchForUsagesRunnable.<init> must not be null");
            }
            this.myUsageCountWithoutDefinition = new AtomicInteger(0);
            this.myFirstUsage = new AtomicReference();
            this.myUsageViewRef = usageView;
            this.myPresentation = presentation;
            this.mySearchFor = searchFor;
            this.mySearcherFactory = searcherFactory;
            this.myProcessPresentation = processPresentation;
            this.myListener = listener;
            UsageViewManagerImpl.this.mySearchHasBeenCancelled = false;
        }

        private UsageViewImpl getUsageView() {
            UsageViewImpl usageView = this.myUsageViewRef.get();
            if (usageView != null) {
                return usageView;
            }
            int usageCount = this.myUsageCountWithoutDefinition.get();
            if (usageCount >= 2 || usageCount == 1 && this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                usageView = new UsageViewImpl(UsageViewManagerImpl.this.myProject, this.myPresentation, this.mySearchFor, this.mySearcherFactory);
                if (this.myUsageViewRef.compareAndSet(null, usageView)) {
                    this.openView(usageView);
                    Usage firstUsage = this.myFirstUsage.get();
                    if (firstUsage != null) {
                        usageView.appendUsageLater(firstUsage);
                    }
                } else {
                    Disposer.dispose((Disposable)usageView);
                }
                return this.myUsageViewRef.get();
            }
            return null;
        }

        private void openView(final UsageViewImpl usageView) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UsageViewManagerImpl.this.addContent(usageView, SearchForUsagesRunnable.this.myPresentation);
                    if (SearchForUsagesRunnable.this.myListener != null) {
                        SearchForUsagesRunnable.this.myListener.usageViewCreated(usageView);
                    }
                    UsageViewManagerImpl.this.showToolWindow(false);
                }
            });
        }

        @Override
        public void run() {
            this.searchUsages();
            this.endSearchForUsages();
        }

        private void searchUsages() {
            UsageSearcher usageSearcher = (UsageSearcher)this.mySearcherFactory.create();
            usageSearcher.generate((Processor)new Processor<Usage>(){

                public boolean process(Usage usage) {
                    ProgressIndicator indicator;
                    boolean incrementCounter;
                    UsageViewManagerImpl.this.checkSearchCanceled();
                    boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, SearchForUsagesRunnable.this.mySearchFor);
                    if (incrementCounter) {
                        UsageViewImpl usageView;
                        int usageCount = SearchForUsagesRunnable.this.myUsageCountWithoutDefinition.incrementAndGet();
                        if (usageCount == 1 && !SearchForUsagesRunnable.this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                            SearchForUsagesRunnable.this.myFirstUsage.compareAndSet(null, usage);
                        }
                        if ((usageView = SearchForUsagesRunnable.this.getUsageView()) != null) {
                            usageView.appendUsageLater(usage);
                        }
                    }
                    return (indicator = ProgressManager.getInstance().getProgressIndicator()) == null || !indicator.isCanceled();
                }
            });
            if (this.getUsageView() != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UsageViewManagerImpl.this.showToolWindow(true);
                    }
                }, UsageViewManagerImpl.this.myProject.getDisposed());
            }
        }

        private void endSearchForUsages() {
            int usageCount = this.myUsageCountWithoutDefinition.get();
            if (usageCount == 0 && this.myProcessPresentation.isShowNotFoundMessage()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<Action> notFoundActions = SearchForUsagesRunnable.this.myProcessPresentation.getNotFoundActions();
                        String message = UsageViewBundle.message("dialog.no.usages.found.in", StringUtil.decapitalize((String)SearchForUsagesRunnable.this.myPresentation.getUsagesString()), SearchForUsagesRunnable.this.myPresentation.getScopeText());
                        if (notFoundActions == null || notFoundActions.isEmpty()) {
                            ToolWindowManager.getInstance(UsageViewManagerImpl.this.myProject).notifyByBalloon(ToolWindowId.FIND, MessageType.INFO, XmlStringUtil.escapeString(message), IconLoader.getIcon((String)"/actions/find.png"), null);
                        } else {
                            ArrayList<String> titles = new ArrayList<String>(notFoundActions.size() + 1);
                            titles.add(UsageViewBundle.message("dialog.button.ok", new Object[0]));
                            for (Action action : notFoundActions) {
                                Object value = action.getValue("NameWithMnemonic");
                                if (value == null) {
                                    value = action.getValue("Name");
                                }
                                titles.add((String)value);
                            }
                            int option = Messages.showDialog(UsageViewManagerImpl.this.myProject, message, UsageViewBundle.message("dialog.title.information", new Object[0]), ArrayUtil.toStringArray(titles), 0, Messages.getInformationIcon());
                            if (option > 0) {
                                notFoundActions.get(option - 1).actionPerformed(new ActionEvent(this, 0, (String)titles.get(option)));
                            }
                        }
                    }
                }, ModalityState.NON_MODAL, UsageViewManagerImpl.this.myProject.getDisposed());
            } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Usage usage = (Usage)SearchForUsagesRunnable.this.myFirstUsage.get();
                        if (usage.canNavigate()) {
                            usage.navigate(true);
                            UsageViewManagerImpl.flashUsageScriptaculously(usage);
                        }
                    }
                });
            } else {
                UsageViewImpl usageView = this.myUsageViewRef.get();
                if (usageView != null) {
                    usageView.setSearchInProgress(false);
                }
            }
            if (this.myListener != null) {
                this.myListener.findingUsagesFinished(this.myUsageViewRef.get());
            }
        }
    }
}

