/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlElementPattern;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlNamedElementPattern<T extends XmlElement & PsiNamedElement, Self extends XmlNamedElementPattern<T, Self>>
extends XmlElementPattern<T, Self> {
    public XmlNamedElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/XmlNamedElementPattern.<init> must not be null");
        }
        super(condition);
    }

    protected abstract String getLocalName(T var1);

    protected abstract String getNamespace(T var1);

    public Self withLocalName(@NonNls String localName) {
        return this.withLocalName((ElementPattern<String>)StandardPatterns.string().equalTo(localName));
    }

    public Self withLocalName(ElementPattern<String> localName) {
        return (Self)((XmlNamedElementPattern)this.with(new PsiNamePatternCondition<T>("withLocalName", localName){

            @Override
            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/XmlNamedElementPattern$1.getPropertyValue must not be null");
                }
                return o instanceof XmlElement ? XmlNamedElementPattern.this.getLocalName((XmlElement)o) : null;
            }
        }));
    }

    public Self withNamespace(String ... namespaces) {
        return this.withNamespace(PlatformPatterns.string().oneOf(namespaces));
    }

    public Self withNamespace(final ElementPattern<String> namespace) {
        return (Self)((XmlNamedElementPattern)this.with(new PatternCondition<T>("withNamespace"){

            @Override
            public boolean accepts(@NotNull T s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/XmlNamedElementPattern$2.accepts must not be null");
                }
                return namespace.accepts(XmlNamedElementPattern.this.getNamespace(s));
            }
        }));
    }

    public static class XmlAttributePattern
    extends XmlNamedElementPattern<XmlAttribute, XmlAttributePattern> {
        protected XmlAttributePattern() {
            super(new InitialPatternCondition<XmlAttribute>(XmlAttribute.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context) {
                    return o instanceof XmlAttribute;
                }
            });
        }

        @Override
        protected String getLocalName(XmlAttribute xmlAttribute) {
            return xmlAttribute.getLocalName();
        }

        @Override
        protected String getNamespace(XmlAttribute xmlAttribute) {
            return xmlAttribute.getNamespace();
        }

        public XmlAttributePattern withValue(final StringPattern pattern) {
            return (XmlAttributePattern)this.with(new PatternCondition<XmlAttribute>("withValue"){

                @Override
                public boolean accepts(@NotNull XmlAttribute xmlAttribute, ProcessingContext context) {
                    if (xmlAttribute == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/XmlNamedElementPattern$XmlAttributePattern$2.accepts must not be null");
                    }
                    return pattern.accepts(xmlAttribute.getValue(), context);
                }
            });
        }
    }
}

