/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Nullable;

public class IgnoredFileBean {
    private final String myPath;
    private final String myMask;
    private final Matcher myMatcher;
    private final IgnoreSettingsType myType;
    private final Project myProject;
    private VirtualFile myCachedResolved;

    IgnoredFileBean(String path, IgnoreSettingsType type, Project project) {
        this.myPath = path;
        this.myType = type;
        this.myProject = project;
        this.myMask = null;
        this.myMatcher = null;
    }

    IgnoredFileBean(String mask) {
        this.myType = IgnoreSettingsType.MASK;
        this.myMask = mask;
        this.myMatcher = mask == null ? null : PatternUtil.fromMask((String)mask).matcher("");
        this.myPath = null;
        this.myProject = null;
    }

    @Nullable
    public String getPath() {
        return this.myPath;
    }

    @Nullable
    public String getMask() {
        return this.myMask;
    }

    public IgnoreSettingsType getType() {
        return this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredFileBean that = (IgnoredFileBean)o;
        if (this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null) {
            return false;
        }
        if (this.myMask != null ? !this.myMask.equals(that.myMask) : that.myMask != null) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.myMask != null ? this.myMask.hashCode() : 0);
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public boolean matchesFile(VirtualFile file) {
        if (this.myType == IgnoreSettingsType.MASK) {
            this.myMatcher.reset(file.getName());
            return this.myMatcher.matches();
        }
        VirtualFile selector = this.resolve();
        if (selector == NullVirtualFile.INSTANCE) {
            return false;
        }
        if (this.myType == IgnoreSettingsType.FILE) {
            return selector == file;
        }
        if ("./".equals(this.myPath)) {
            return !file.isDirectory() && file.getParent() == selector;
        }
        return VfsUtil.isAncestor(selector, file, false);
    }

    private VirtualFile resolve() {
        if (this.myCachedResolved == null) {
            VirtualFile resolved = this.doResolve();
            this.myCachedResolved = resolved != null ? resolved : NullVirtualFile.INSTANCE;
        }
        return this.myCachedResolved;
    }

    @Nullable
    private VirtualFile doResolve() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        String path = FileUtil.toSystemIndependentName((String)this.myPath);
        if (baseDir == null) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        VirtualFile resolvedRelative = baseDir.findFileByRelativePath(path);
        if (resolvedRelative != null) {
            return resolvedRelative;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public void resetCache() {
        this.myCachedResolved = null;
    }
}

