/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public abstract class PresentableNodeDescriptor<E>
extends NodeDescriptor<E> {
    private PresentationData myTemplatePresentation;
    private PresentationData myUpdatedPresentation;

    protected PresentableNodeDescriptor(Project project, NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
    }

    @Override
    public final boolean update() {
        if (this.shouldUpdateData()) {
            return this.apply(this.getUpdatedPresentation());
        }
        return false;
    }

    protected final boolean apply(PresentationData presentation) {
        this.myOpenIcon = presentation.getIcon(true);
        this.myClosedIcon = presentation.getIcon(false);
        this.myName = presentation.getPresentableText();
        this.myColor = presentation.getForcedTextForeground();
        boolean updated = presentation.equals(this.myUpdatedPresentation);
        if (this.myUpdatedPresentation == null) {
            this.myUpdatedPresentation = this.createPresentation();
        }
        this.myUpdatedPresentation.copyFrom(presentation);
        if (this.myTemplatePresentation != null) {
            this.myUpdatedPresentation.applyFrom(this.myTemplatePresentation);
        }
        return updated;
    }

    private PresentationData getUpdatedPresentation() {
        PresentationData presentation;
        this.myUpdatedPresentation = presentation = this.myUpdatedPresentation != null ? this.myUpdatedPresentation : this.createPresentation();
        presentation.clear();
        this.update(presentation);
        this.postprocess(presentation);
        return presentation;
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData presentationData = new PresentationData();
        if (presentationData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/PresentableNodeDescriptor.createPresentation must not return null");
        }
        return presentationData;
    }

    protected void postprocess(PresentationData date) {
    }

    protected abstract void update(PresentationData var1);

    protected boolean shouldUpdateData() {
        return true;
    }

    @NotNull
    public final PresentationData getPresentation() {
        PresentationData result = this.myUpdatedPresentation == null ? this.getTemplatePresentation() : this.myUpdatedPresentation;
        PresentationData presentationData = result;
        if (presentationData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/PresentableNodeDescriptor.getPresentation must not return null");
        }
        return presentationData;
    }

    protected final PresentationData getTemplatePresentation() {
        if (this.myTemplatePresentation == null) {
            this.myTemplatePresentation = this.createPresentation();
        }
        return this.myTemplatePresentation;
    }

    public boolean isContentHighlighted() {
        return false;
    }

    public boolean isHighlightableContentNode(PresentableNodeDescriptor kid) {
        return true;
    }

    public abstract PresentableNodeDescriptor getChildToHighlightAt(int var1);

    public boolean isParentOf(NodeDescriptor eachNode) {
        for (NodeDescriptor eachParent = eachNode.getParentDescriptor(); eachParent != null; eachParent = eachParent.getParentDescriptor()) {
            if (eachParent != this) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOrSelf(NodeDescriptor selectedNode) {
        for (NodeDescriptor node = selectedNode; node != null; node = node.getParentDescriptor()) {
            if (!this.equals(node)) continue;
            return true;
        }
        return false;
    }

    public Color getHighlightColor() {
        return new Color(245, 245, 245);
    }

    public String getName() {
        if (this.getPresentation().getColoredText().size() > 0) {
            StringBuilder result = new StringBuilder("");
            for (ColoredFragment each : this.getPresentation().getColoredText()) {
                result.append(each.getText());
            }
            return result.toString();
        }
        return this.myName;
    }

    public static class ColoredFragment {
        private final String myText;
        private final String myToolTip;
        private final SimpleTextAttributes myAttributes;

        public ColoredFragment(String aText, SimpleTextAttributes aAttributes) {
            this(aText, null, aAttributes);
        }

        public ColoredFragment(String aText, String toolTip, SimpleTextAttributes aAttributes) {
            this.myText = aText == null ? "" : aText;
            this.myAttributes = aAttributes;
            this.myToolTip = toolTip;
        }

        public String getToolTip() {
            return this.myToolTip;
        }

        public String getText() {
            return this.myText;
        }

        public SimpleTextAttributes getAttributes() {
            return this.myAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredFragment that = (ColoredFragment)o;
            if (this.myAttributes != null ? !this.myAttributes.equals(that.myAttributes) : that.myAttributes != null) {
                return false;
            }
            if (this.myText != null ? !this.myText.equals(that.myText) : that.myText != null) {
                return false;
            }
            return !(this.myToolTip != null ? !this.myToolTip.equals(that.myToolTip) : that.myToolTip != null);
        }

        public int hashCode() {
            int result = this.myText != null ? this.myText.hashCode() : 0;
            result = 31 * result + (this.myToolTip != null ? this.myToolTip.hashCode() : 0);
            result = 31 * result + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
            return result;
        }
    }
}

