/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.NonNls;

public class ProcessTerminatedListener
extends ProcessAdapter {
    private static final Key<ProcessTerminatedListener> KEY = new Key("processTerminatedListener");
    private final String myProcessFinishedMessage;
    private final Project myProject;
    @NonNls
    protected static final String EXIT_CODE_ENTRY = "$EXIT_CODE$";
    @NonNls
    protected static final String EXIT_CODE_REGEX = "\\$EXIT_CODE\\$";

    private ProcessTerminatedListener(Project project, String processFinishedMessage) {
        this.myProject = project;
        this.myProcessFinishedMessage = processFinishedMessage;
    }

    public static void attach(ProcessHandler processHandler, Project project, String message) {
        ProcessTerminatedListener previousListener = (ProcessTerminatedListener)processHandler.getUserData(KEY);
        if (previousListener != null) {
            processHandler.removeProcessListener(previousListener);
            if (project == null) {
                project = previousListener.myProject;
            }
        }
        ProcessTerminatedListener listener = new ProcessTerminatedListener(project, message);
        processHandler.addProcessListener(listener);
        processHandler.putUserData(KEY, listener);
    }

    public static void attach(ProcessHandler processHandler, Project project) {
        String message = IdeBundle.message("finished.with.exit.code.text.message", EXIT_CODE_ENTRY);
        ProcessTerminatedListener.attach(processHandler, project, "\n" + message + "\n");
    }

    public static void attach(ProcessHandler processHandler) {
        ProcessTerminatedListener.attach(processHandler, null);
    }

    @Override
    public void processTerminated(ProcessEvent event) {
        ProcessHandler processHandler = event.getProcessHandler();
        processHandler.removeProcessListener(this);
        final String message = this.myProcessFinishedMessage.replaceAll(EXIT_CODE_REGEX, String.valueOf(event.getExitCode()));
        processHandler.notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        if (this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProcessTerminatedListener.this.myProject.isDisposed()) {
                        return;
                    }
                    WindowManager.getInstance().getStatusBar(ProcessTerminatedListener.this.myProject).setInfo(message);
                }
            });
        }
    }
}

