/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean classIsInLibrary(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/LibraryUtil.classIsInLibrary must not be null");
        }
        return aClass instanceof PsiCompiledElement;
    }

    public static boolean callOnLibraryMethod(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/LibraryUtil.callOnLibraryMethod must not be null");
        }
        PsiMethod method = expression.resolveMethod();
        return method != null && method instanceof PsiCompiledElement;
    }

    public static boolean isOverrideOfLibraryMethod(PsiMethod method) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass != null && LibraryUtil.classIsInLibrary(containingClass)) {
                return true;
            }
            if (!LibraryUtil.isOverrideOfLibraryMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverrideOfLibraryMethodParameter(PsiVariable variable) {
        PsiMethod method;
        PsiParameter parameter;
        PsiElement scope;
        return variable instanceof PsiParameter && (scope = (parameter = (PsiParameter)variable).getDeclarationScope()) instanceof PsiMethod && LibraryUtil.isOverrideOfLibraryMethod(method = (PsiMethod)scope);
    }
}

