/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToSimpleGetterInClassInspection
extends BaseInspection {
    public boolean ignoreGetterCallsOnOtherObjects = false;

    @NotNull
    public String getID() {
        if ("CallToSimpleGetterFromWithinClass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleGetterInClassInspection.getID must not return null");
        }
        return "CallToSimpleGetterFromWithinClass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleGetterInClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleGetterInClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("call.to.simple.getter.in.class.display.name.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreGetterCallsOnOtherObjects");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleGetterInClassVisitor();
    }

    private class CallToSimpleGetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleGetterInClassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/CallToSimpleGetterInClassInspection$CallToSimpleGetterInClassVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleGetterInClassInspection.this.ignoreGetterCallsOnOtherObjects) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type;
                PsiClass qualifierClass = classType.resolve();
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!MethodUtils.isSimpleGetter(method)) {
                return;
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true);
            PsiMethod overridingMethod = (PsiMethod)query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }
    }

    private static class InlineCallFix
    extends InspectionGadgetsFix {
        private InlineCallFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.inline.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleGetterInClassInspection$InlineCallFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodIdentifier = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodIdentifier.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)methodExpression.getParent();
            if (call == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            PsiReturnStatement returnStatement = (PsiReturnStatement)statements[0];
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiField field = (PsiField)referenceExpression.resolve();
            if (field == null) {
                return;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)call.getProject());
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiVariable variable = resolveHelper.resolveReferencedVariable(fieldName, (PsiElement)call);
                if (variable == null) {
                    return;
                }
                if (variable.equals(field)) {
                    InlineCallFix.replaceExpression((PsiExpression)call, fieldName);
                } else {
                    InlineCallFix.replaceExpression((PsiExpression)call, "this." + fieldName);
                }
            } else {
                InlineCallFix.replaceExpression((PsiExpression)call, qualifier.getText() + '.' + fieldName);
            }
        }
    }
}

