/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableIfStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/SimplifiableIfStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableIfStatementVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiIfStatement statement = (PsiIfStatement)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.if.statement.problem.descriptor", SimplifiableIfStatementInspection.calculateReplacementStatement(statement));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/SimplifiableIfStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @NonNls
    static String calculateReplacementStatement(PsiIfStatement statement) {
        PsiElement nextStatement;
        PsiStatement thenBranch = statement.getThenBranch();
        if ((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) == null) {
            return "";
        }
        PsiStatement elseBranch = statement.getElseBranch();
        if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null && (nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiStatement) {
            elseBranch = (PsiStatement)nextStatement;
        }
        if (elseBranch == null) {
            return "";
        }
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return "";
        }
        if (elseBranch instanceof PsiReturnStatement) {
            return SimplifiableIfStatementInspection.calculateReplacementReturnStatement(thenBranch, elseBranch, condition);
        }
        PsiExpressionStatement thenStatement = (PsiExpressionStatement)thenBranch;
        PsiExpressionStatement elseStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression thenAssignment = (PsiAssignmentExpression)thenStatement.getExpression();
        PsiAssignmentExpression elseAssignment = (PsiAssignmentExpression)elseStatement.getExpression();
        return SimplifiableIfStatementInspection.calculateReplacementAssignmentStatement(thenAssignment, elseAssignment, condition);
    }

    private static String calculateReplacementAssignmentStatement(PsiAssignmentExpression thenAssignment, PsiAssignmentExpression elseAssignment, PsiExpression condition) {
        PsiExpression lhs = thenAssignment.getLExpression();
        PsiExpression thenRhs = thenAssignment.getRExpression();
        if (thenRhs == null) {
            return "";
        }
        PsiExpression elseRhs = elseAssignment.getRExpression();
        if (elseRhs == null) {
            return "";
        }
        PsiJavaToken token = elseAssignment.getOperationSign();
        if (BoolUtils.isTrue(thenRhs)) {
            if (ParenthesesUtils.getPrecedence(elseRhs) > 14) {
                return lhs.getText() + ' ' + token.getText() + ' ' + condition.getText() + " || (" + elseRhs.getText() + ");";
            }
            return lhs.getText() + ' ' + token.getText() + ' ' + condition.getText() + " || " + elseRhs.getText() + ';';
        }
        if (BoolUtils.isFalse(thenRhs)) {
            if (ParenthesesUtils.getPrecedence(elseRhs) > 13) {
                return lhs.getText() + ' ' + token.getText() + ' ' + BoolUtils.getNegatedExpressionText(condition) + " && (" + elseRhs.getText() + ");";
            }
            return lhs.getText() + ' ' + token.getText() + ' ' + BoolUtils.getNegatedExpressionText(condition) + " && " + elseRhs.getText() + ';';
        }
        if (BoolUtils.isTrue(elseRhs)) {
            if (ParenthesesUtils.getPrecedence(thenRhs) > 14) {
                return lhs.getText() + ' ' + token.getText() + ' ' + BoolUtils.getNegatedExpressionText(condition) + " || (" + thenRhs.getText() + ");";
            }
            return lhs.getText() + ' ' + token.getText() + ' ' + BoolUtils.getNegatedExpressionText(condition) + " || " + thenRhs.getText() + ';';
        }
        String conditionText = ParenthesesUtils.getPrecedence(condition) > 13 ? '(' + condition.getText() + ')' : condition.getText();
        if (ParenthesesUtils.getPrecedence(thenRhs) > 13) {
            return lhs.getText() + ' ' + token.getText() + ' ' + conditionText + " && (" + thenRhs.getText() + ");";
        }
        return lhs.getText() + ' ' + token.getText() + ' ' + conditionText + " && " + thenRhs.getText() + ';';
    }

    @NonNls
    private static String calculateReplacementReturnStatement(PsiStatement thenBranch, PsiStatement elseBranch, PsiExpression condition) {
        PsiReturnStatement thenReturnStatement = (PsiReturnStatement)thenBranch;
        PsiExpression thenReturnValue = thenReturnStatement.getReturnValue();
        if (thenReturnValue == null) {
            return "";
        }
        PsiReturnStatement elseReturnStatement = (PsiReturnStatement)elseBranch;
        PsiExpression elseReturnValue = elseReturnStatement.getReturnValue();
        if (elseReturnValue == null) {
            return "";
        }
        if (BoolUtils.isTrue(thenReturnValue)) {
            if (ParenthesesUtils.getPrecedence(elseReturnValue) > 14) {
                return "return " + condition.getText() + " || (" + elseReturnValue.getText() + ");";
            }
            return "return " + condition.getText() + " || " + elseReturnValue.getText() + ';';
        }
        if (BoolUtils.isFalse(thenReturnValue)) {
            if (ParenthesesUtils.getPrecedence(elseReturnValue) > 13) {
                return "return " + BoolUtils.getNegatedExpressionText(condition) + " && (" + elseReturnValue.getText() + ");";
            }
            return "return " + BoolUtils.getNegatedExpressionText(condition) + " && " + elseReturnValue.getText() + ';';
        }
        if (BoolUtils.isTrue(elseReturnValue)) {
            if (ParenthesesUtils.getPrecedence(thenReturnValue) > 14) {
                return "return " + BoolUtils.getNegatedExpressionText(condition) + " || (" + thenReturnValue.getText() + ");";
            }
            return "return " + BoolUtils.getNegatedExpressionText(condition) + " || " + thenReturnValue.getText() + ';';
        }
        String conditionText = ParenthesesUtils.getPrecedence(condition) > 13 ? '(' + condition.getText() + ')' : condition.getText();
        if (ParenthesesUtils.getPrecedence(thenReturnValue) > 13) {
            return "return " + conditionText + " && (" + thenReturnValue.getText() + ");";
        }
        return "return " + conditionText + " && " + thenReturnValue.getText() + ';';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableIfStatementFix();
    }

    private static class SimplifiableIfStatementVisitor
    extends BaseInspectionVisitor {
        private SimplifiableIfStatementVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            if (statement.getCondition() == null) {
                return;
            }
            if (!SimplifiableIfStatementVisitor.isReplaceableAssignment(statement) && !SimplifiableIfStatementVisitor.isReplaceableReturn(statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, statement);
        }

        public static boolean isReplaceableReturn(PsiIfStatement ifStatement) {
            PsiElement nextStatement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            thenBranch = ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null && (nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiStatement) {
                elseBranch = (PsiStatement)nextStatement;
            }
            if (!(thenBranch instanceof PsiReturnStatement) || !(elseBranch instanceof PsiReturnStatement)) {
                return false;
            }
            PsiExpression thenReturn = ((PsiReturnStatement)thenBranch).getReturnValue();
            if (thenReturn == null) {
                return false;
            }
            PsiExpression elseReturn = ((PsiReturnStatement)elseBranch).getReturnValue();
            if (elseReturn == null) {
                return false;
            }
            boolean thenConstant = BoolUtils.isFalse(thenReturn) || BoolUtils.isTrue(thenReturn);
            boolean elseConstant = BoolUtils.isFalse(elseReturn) || BoolUtils.isTrue(elseReturn);
            return thenConstant != elseConstant;
        }

        public static boolean isReplaceableAssignment(PsiIfStatement ifStatement) {
            boolean elseConstant;
            PsiJavaToken elseOperationSign;
            IElementType elseTokenType;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return false;
            }
            if ((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) == null || !SimplifiableIfStatementVisitor.isAssignment(thenBranch)) {
                return false;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null || !SimplifiableIfStatementVisitor.isAssignment(elseBranch)) {
                return false;
            }
            PsiExpressionStatement thenStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenStatement.getExpression();
            PsiExpressionStatement elseStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseStatement.getExpression();
            PsiJavaToken thenOperationSign = thenExpression.getOperationSign();
            IElementType thenTokenType = thenOperationSign.getTokenType();
            if (!thenTokenType.equals(elseTokenType = (elseOperationSign = elseExpression.getOperationSign()).getTokenType())) {
                return false;
            }
            PsiExpression thenRhs = thenExpression.getRExpression();
            if (thenRhs == null) {
                return false;
            }
            PsiExpression elseRhs = elseExpression.getRExpression();
            if (elseRhs == null) {
                return false;
            }
            boolean thenConstant = BoolUtils.isFalse(thenRhs) || BoolUtils.isTrue(thenRhs);
            boolean bl = elseConstant = BoolUtils.isFalse(elseRhs) || BoolUtils.isTrue(elseRhs);
            if (thenConstant == elseConstant) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }

        public static boolean isAssignment(@Nullable PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            return expression instanceof PsiAssignmentExpression;
        }
    }

    private static class SimplifiableIfStatementFix
    extends InspectionGadgetsFix {
        private SimplifiableIfStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/SimplifiableIfStatementInspection$SimplifiableIfStatementFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement nextStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            String newStatement = SimplifiableIfStatementInspection.calculateReplacementStatement(ifStatement);
            if ("".equals(newStatement)) {
                return;
            }
            if (ifStatement.getElseBranch() == null && (nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class})) != null) {
                nextStatement.delete();
            }
            SimplifiableIfStatementFix.replaceStatement((PsiStatement)ifStatement, newStatement);
        }
    }
}

