/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ConditionalExpressionInspection
extends BaseInspection {
    public boolean ignoreSimpleAssignmentsAndReturns = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConditionalExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("conditional.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConditionalExpressionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("conditional.expression.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSimpleAssignmentsAndReturns");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionVisitor();
    }

    private class ConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            if (ConditionalExpressionInspection.this.ignoreSimpleAssignmentsAndReturns) {
                PsiElement parent = expression.getParent();
                while (parent instanceof PsiParenthesizedExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiAssignmentExpression || parent instanceof PsiReturnStatement || parent instanceof PsiLocalVariable) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

