/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.ant.execution;

import com.intellij.rt.ant.execution.PacketFactory;
import com.intellij.rt.execution.junit.segments.PacketWriter;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;

public final class IdeaAntLogger2
extends DefaultLogger {
    static SegmentedOutputStream ourOut;
    static SegmentedOutputStream ourErr;
    public static final char MESSAGE_CONTENT = 'M';
    public static final char EXCEPTION_CONTENT = 'X';
    public static final char INPUT_REQUEST = 'I';
    public static final char BUILD_END = 'b';
    public static final char BUILD = 'B';
    public static final char TARGET = 'G';
    public static final char TARGET_END = 'g';
    public static final char TASK = 'T';
    public static final char TASK_END = 't';
    public static final char MESSAGE = 'M';
    public static final char ERROR = 'E';
    public static final char EXCEPTION = 'X';
    public static final char EXCEPTION_LINE_SEPARATOR = '\u0000';
    public static final String OUTPUT_PREFIX = "IDEA_ANT_INTEGRATION";
    private final Priority myMessagePriority = new MessagePriority();
    private final Priority myTargetPriority = new StatePriority(2);
    private final Priority myTaskPriority = new StatePriority(2);
    private final Priority myAlwaysSend = new Priority(){

        public void setPriority(int level) {
        }

        protected boolean shouldSend(int priority) {
            return true;
        }
    };

    public IdeaAntLogger2() {
        IdeaAntLogger2.guardStreams();
    }

    public synchronized void setMessageOutputLevel(int level) {
        super.setMessageOutputLevel(level);
        this.myMessagePriority.setPriority(level);
        this.myTargetPriority.setPriority(level);
        this.myTaskPriority.setPriority(level);
        this.myAlwaysSend.setPriority(level);
    }

    public synchronized void buildStarted(BuildEvent event) {
        this.myAlwaysSend.sendMessage('B', event.getPriority(), "");
    }

    public synchronized void buildFinished(BuildEvent event) {
        this.myAlwaysSend.sendMessage('b', event.getPriority(), event.getException());
    }

    public synchronized void targetStarted(BuildEvent event) {
        this.myTargetPriority.sendMessage('G', event.getPriority(), event.getTarget().getName());
    }

    public synchronized void targetFinished(BuildEvent event) {
        this.sendException(event);
        this.myTargetPriority.sendMessage('g', event.getPriority(), event.getException());
    }

    public synchronized void taskStarted(BuildEvent event) {
        this.myTaskPriority.sendMessage('T', event.getPriority(), event.getTask().getTaskName());
    }

    public synchronized void taskFinished(BuildEvent event) {
        this.sendException(event);
        this.myTaskPriority.sendMessage('t', event.getPriority(), event.getException());
    }

    public synchronized void messageLogged(BuildEvent event) {
        if (this.sendException(event)) {
            return;
        }
        int priority = event.getPriority();
        String message = event.getMessage();
        if (priority == 0) {
            this.myMessagePriority.sendMessage('E', priority, message);
        } else {
            this.myMessagePriority.sendMessage('M', priority, message);
        }
    }

    private boolean sendException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception != null) {
            this.myAlwaysSend.sendMessage('X', event.getPriority(), exception);
            return true;
        }
        return false;
    }

    public static void guardStreams() {
        if (ourErr != null && ourOut != null) {
            return;
        }
        PrintStream out = System.out;
        PrintStream err = System.err;
        ourOut = new SegmentedOutputStream(out);
        ourErr = new SegmentedOutputStream(err);
        System.setOut(new PrintStream(ourOut));
        System.setErr(new PrintStream(ourErr));
        ourOut.sendStart();
        ourErr.sendStart();
    }

    private void send(PacketWriter packet) {
        packet.sendThrough(ourOut);
        packet.sendThrough(ourErr);
    }

    private PacketWriter createPacket(char id, int priority) {
        PacketWriter packet = PacketFactory.ourInstance.createPacket(id);
        packet.appendLong(priority);
        return packet;
    }

    private class StatePriority
    extends Priority {
        private boolean myEnabled = true;
        private final int myMinLevel;

        public StatePriority(int minLevel) {
            this.myMinLevel = minLevel;
        }

        public void setPriority(int level) {
            this.myEnabled = this.myMinLevel <= level;
        }

        protected boolean shouldSend(int priority) {
            return this.myEnabled;
        }
    }

    private class MessagePriority
    extends Priority {
        private int myPriority = 0;

        private MessagePriority() {
        }

        public void setPriority(int level) {
            this.myPriority = level;
        }

        protected boolean shouldSend(int priority) {
            return priority <= this.myPriority;
        }
    }

    private abstract class Priority {
        private Priority() {
        }

        protected void peformSendMessage(char id, int priority, String text) {
            PacketWriter packet = IdeaAntLogger2.this.createPacket(id, priority);
            packet.appendChar('M');
            packet.appendLimitedString(text);
            IdeaAntLogger2.this.send(packet);
        }

        protected void peformSendMessage(char id, int priority, Throwable throwable) {
            if (throwable != null) {
                PacketWriter packet = IdeaAntLogger2.this.createPacket(id, priority);
                StringWriter stackTrace = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stackTrace));
                packet.appendChar('X');
                packet.appendLimitedString(stackTrace.toString());
                IdeaAntLogger2.this.send(packet);
            } else {
                this.peformSendMessage(id, priority, "");
            }
        }

        public void sendMessage(char id, int priority, String text) {
            if (this.shouldSend(priority)) {
                this.peformSendMessage(id, priority, text);
            }
        }

        public void sendMessage(char id, int priority, Throwable throwable) {
            if (this.shouldSend(priority)) {
                this.peformSendMessage(id, priority, throwable);
            }
        }

        public abstract void setPriority(int var1);

        protected abstract boolean shouldSend(int var1);
    }
}

