/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.StatisticsTable;
import com.intellij.execution.junit2.ui.TestColumnInfo;
import com.intellij.execution.junit2.ui.TestTableRenderer;
import com.intellij.execution.junit2.ui.actions.TestContext;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableToolTipHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.TableView;
import com.intellij.util.config.Storage;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class StatisticsPanel
extends JPanel
implements DataProvider {
    private final MyJUnitListener myListener = new MyJUnitListener();
    private TestProxy myCurrentTest = null;
    private StatisticsTable myChildInfo = null;
    private JUnitRunningModel myModel;
    private final TableView myTable;
    private final Storage.PropertiesComponentStorage myStorage = new Storage.PropertiesComponentStorage("junit_statistics_table_columns");

    public StatisticsPanel() {
        super(new BorderLayout(0, 0));
        this.myChildInfo = new StatisticsTable(TestColumnInfo.COLUMN_NAMES);
        this.myTable = new TableView(this.myChildInfo){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new TestTableRenderer(TestColumnInfo.COLUMN_NAMES);
            }
        };
        PopupHandler.installPopupHandler((JComponent)this.myTable, (String)"TestStatisticsTablePopupMenu", (String)"TestStatisticsViewPopup");
        this.add((Component)this.myTable, "Center");
    }

    private void updateStatistics() {
        this.myTable.setVisible(true);
        if (this.myCurrentTest.isLeaf() && this.myCurrentTest.getParent() != null) {
            this.myChildInfo.updateStatistics(this.myCurrentTest.getParent());
        } else {
            this.myChildInfo.updateStatistics(this.myCurrentTest);
        }
        int idx = this.myChildInfo.getIndexOf((Object)this.myCurrentTest);
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{idx});
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
    }

    public void attachTo(JUnitRunningModel model) {
        this.myModel = model;
        this.myModel.addListener(this.myListener);
        this.myChildInfo.setModel(model);
        TableToolTipHandler.install((JTable)this.myTable);
        BaseTableView.restore((Storage)this.myStorage, (JTable)this.myTable);
    }

    public Object getData(String dataId) {
        if (this.myModel == null) {
            return null;
        }
        TestProxy selectedTest = this.myChildInfo.getTestAt(this.myTable.getSelectedRow());
        if (TestContext.DATA_KEY.is(dataId)) {
            return new TestContext(this.myModel, selectedTest);
        }
        return TestsUIUtil.getData((AbstractTestProxy)selectedTest, (String)dataId, (TestFrameworkRunningModel)this.myModel);
    }

    private class MyJUnitListener
    extends JUnitAdapter {
        private MyJUnitListener() {
        }

        @Override
        public void onTestChanged(TestEvent event) {
            if (!StatisticsPanel.this.isShowing()) {
                return;
            }
            if (StatisticsPanel.this.myCurrentTest == event.getSource()) {
                StatisticsPanel.this.updateStatistics();
            }
        }

        @Override
        public void onTestSelected(TestProxy test) {
            if (!StatisticsPanel.this.isShowing()) {
                return;
            }
            if (StatisticsPanel.this.myCurrentTest == test) {
                return;
            }
            if (test == null) {
                StatisticsPanel.this.myTable.setVisible(false);
                return;
            }
            StatisticsPanel.this.myCurrentTest = test;
            StatisticsPanel.this.updateStatistics();
        }

        @Override
        public void doDispose() {
            BaseTableView.store((Storage)StatisticsPanel.this.myStorage, (JTable)StatisticsPanel.this.myTable);
            StatisticsPanel.this.myTable.setModel(new ListTableModel(TestColumnInfo.COLUMN_NAMES));
            StatisticsPanel.this.myModel = null;
            StatisticsPanel.this.myChildInfo = null;
            StatisticsPanel.this.myCurrentTest = null;
        }
    }
}

