/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfigurationType;

public class GroovyScriptRunConfigurationProducer
extends RuntimeConfigurationProducer
implements Cloneable {
    private PsiElement mySourceElement;

    public GroovyScriptRunConfigurationProducer() {
        super((ConfigurationType)GroovyScriptRunConfigurationType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
        PsiElement element = location.getPsiElement();
        PsiFile file = element.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile.isScript()) {
            this.mySourceElement = element;
            RunnerAndConfigurationSettings settings = GroovyScriptRunConfigurationType.getInstance().createConfigurationByLocation(location);
            if (settings != null) {
                GroovyScriptRunConfiguration configuration = (GroovyScriptRunConfiguration)settings.getConfiguration();
                GroovyScriptType.getScriptType(groovyFile).tuneConfiguration(groovyFile, configuration, location);
                return (RunnerAndConfigurationSettingsImpl)settings;
            }
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

