/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticMethodImplementation;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GrClassImplUtil {
    private static final Condition<PsiClassType> IS_GROOVY_OBJECT = new Condition<PsiClassType>(){

        public boolean value(PsiClassType psiClassType) {
            return psiClassType.equalsToText("groovy.lang.GroovyObject");
        }
    };

    private GrClassImplUtil() {
    }

    @Nullable
    public static PsiClass getSuperClass(GrTypeDefinition grType) {
        PsiClassType[] extendsList = grType.getExtendsListTypes();
        if (extendsList.length == 0) {
            return GrClassImplUtil.getBaseClass(grType);
        }
        PsiClass superClass = extendsList[0].resolve();
        return superClass != null ? superClass : GrClassImplUtil.getBaseClass(grType);
    }

    @Nullable
    public static PsiClass getBaseClass(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Enum", grType.getResolveScope());
        }
        return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Object", grType.getResolveScope());
    }

    @NotNull
    public static PsiClassType[] getExtendsListTypes(GrTypeDefinition grType) {
        List<PsiClassType> extendsTypes = GrClassImplUtil.getReferenceListTypes(grType.getExtendsClause());
        PsiClassType[] psiClassTypeArray = extendsTypes.toArray(new PsiClassType[extendsTypes.size()]);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @NotNull
    public static PsiClassType[] getImplementsListTypes(GrTypeDefinition grType) {
        List<PsiClassType> implementsTypes = GrClassImplUtil.getReferenceListTypes(grType.getImplementsClause());
        if (!(grType.isInterface() || ContainerUtil.or(implementsTypes, IS_GROOVY_OBJECT) || ContainerUtil.or(GrClassImplUtil.getReferenceListTypes(grType.getExtendsClause()), IS_GROOVY_OBJECT))) {
            implementsTypes.add(GrClassImplUtil.getGroovyObjectType(grType));
        }
        PsiClassType[] psiClassTypeArray = implementsTypes.toArray(new PsiClassType[implementsTypes.size()]);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.getImplementsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    private static PsiClassType getGroovyObjectType(GrTypeDefinition grType) {
        return JavaPsiFacade.getInstance((Project)grType.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.GroovyObject", grType.getResolveScope());
    }

    @NotNull
    public static PsiClassType[] getSuperTypes(GrTypeDefinition grType) {
        Object[] extendsList = grType.getExtendsListTypes();
        if (extendsList.length == 0) {
            extendsList = new PsiClassType[]{GrClassImplUtil.createBaseClassType(grType)};
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])ArrayUtil.mergeArrays((Object[])extendsList, (Object[])grType.getImplementsListTypes(), PsiClassType.class);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    public static PsiClassType createBaseClassType(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return JavaPsiFacade.getInstance((Project)grType.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Enum", grType.getResolveScope());
        }
        return JavaPsiFacade.getInstance((Project)grType.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Object", grType.getResolveScope());
    }

    @NotNull
    public static PsiMethod[] getAllMethods(GrTypeDefinition grType) {
        ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
        GrClassImplUtil.getAllMethodsInner(grType, allMethods, new HashSet<PsiClass>());
        PsiMethod[] psiMethodArray = allMethods.toArray(new PsiMethod[allMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    private static void getAllMethodsInner(PsiClass clazz, List<PsiMethod> allMethods, HashSet<PsiClass> visited) {
        PsiField[] fields;
        if (visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        allMethods.addAll(Arrays.asList(clazz.getMethods()));
        for (PsiField field : fields = clazz.getFields()) {
            GrAccessorMethod setter;
            GrField groovyField;
            if (!(field instanceof GrField) || !(groovyField = (GrField)field).isProperty()) continue;
            GrAccessorMethod[] getters = groovyField.getGetters();
            if (getters.length > 0) {
                allMethods.addAll(Arrays.asList(getters));
            }
            if ((setter = groovyField.getSetter()) == null) continue;
            allMethods.add(setter);
        }
        PsiClass[] supers = clazz.getSupers();
        if (supers.length < 2) {
            GrClassImplUtil.addGroovyObjectMethods(clazz, allMethods);
        }
        for (PsiClass aSuper : supers) {
            GrClassImplUtil.getAllMethodsInner(aSuper, allMethods, visited);
        }
    }

    public static void addGroovyObjectMethods(PsiClass clazz, List<PsiMethod> allMethods) {
        PsiClass groovyObject;
        if (clazz instanceof GrTypeDefinition && !clazz.isInterface() && (groovyObject = JavaPsiFacade.getInstance((Project)clazz.getProject()).findClass("groovy.lang.GroovyObject", clazz.getResolveScope())) != null) {
            for (PsiMethod method : groovyObject.getMethods()) {
                allMethods.add(new GrSyntheticMethodImplementation(method, clazz));
            }
        }
    }

    private static List<PsiClassType> getReferenceListTypes(@Nullable GrReferenceList list) {
        ArrayList<PsiClassType> types = new ArrayList<PsiClassType>();
        if (list != null) {
            for (GrCodeReferenceElement ref : list.getReferenceElements()) {
                types.add(new GrClassReferenceType(ref));
            }
        }
        return types;
    }

    public static PsiClass[] getInterfaces(GrTypeDefinition grType) {
        PsiClassType[] implementsListTypes = grType.getImplementsListTypes();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(implementsListTypes.length);
        for (PsiClassType type : implementsListTypes) {
            PsiClass psiClass = type.resolve();
            if (psiClass == null) continue;
            result.add(psiClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    @NotNull
    public static PsiClass[] getSupers(GrTypeDefinition grType) {
        PsiClassType[] superTypes = grType.getSuperTypes();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClassType superType : superTypes) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            result.add(superClass);
        }
        PsiClass[] psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.getSupers must not return null");
        }
        return psiClassArray;
    }

    public static boolean processDeclarations(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        GrTypeDefinitionBody body;
        if (grType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.processDeclarations must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.processDeclarations must not be null");
        }
        for (PsiTypeParameter typeParameter : grType.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter)) continue;
            return false;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint == null ? null : nameHint.getName(state);
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        if (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.PROPERTY)) {
            Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
            if (name != null) {
                PsiField field;
                CandidateInfo fieldInfo = fieldsMap.get(name);
                if (fieldInfo != null && !GrClassImplUtil.isSameDeclaration(place, (PsiElement)(field = (PsiField)fieldInfo.getElement()))) {
                    PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)field.getContainingClass(), (PsiSubstitutor)fieldInfo.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElement)place, (PsiElementFactory)factory);
                    if (!processor.execute((PsiElement)field, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)finalSubstitutor))) {
                        return false;
                    }
                }
            } else {
                for (CandidateInfo info : fieldsMap.values()) {
                    PsiField field = (PsiField)info.getElement();
                    if (GrClassImplUtil.isSameDeclaration(place, (PsiElement)field)) continue;
                    PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)field.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElement)place, (PsiElementFactory)factory);
                    if (processor.execute((PsiElement)field, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)finalSubstitutor))) continue;
                    return false;
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.METHOD)) {
            boolean isPlaceGroovy;
            Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
            boolean bl = isPlaceGroovy = place.getLanguage() == GroovyFileType.GROOVY_FILE_TYPE.getLanguage();
            if (name == null) {
                for (List<CandidateInfo> list : methodsMap.values()) {
                    for (CandidateInfo info : list) {
                        PsiMethod method = (PsiMethod)info.getElement();
                        if (GrClassImplUtil.isSameDeclaration(place, (PsiElement)method) || !GrClassImplUtil.isMethodVisible(isPlaceGroovy, method)) continue;
                        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)method.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElement)place, (PsiElementFactory)factory);
                        if (processor.execute((PsiElement)method, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)finalSubstitutor))) continue;
                        return false;
                    }
                }
            } else {
                List<CandidateInfo> byName = methodsMap.get(name);
                if (byName != null) {
                    for (CandidateInfo info : byName) {
                        PsiMethod method = (PsiMethod)info.getElement();
                        if (GrClassImplUtil.isSameDeclaration(place, (PsiElement)method) || !GrClassImplUtil.isMethodVisible(isPlaceGroovy, method)) continue;
                        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)method.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElement)place, (PsiElementFactory)factory);
                        if (processor.execute((PsiElement)method, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)finalSubstitutor))) continue;
                        return false;
                    }
                }
            }
        }
        if ((body = grType.getBody()) != null && !GrClassImplUtil.isSuperClassReferenceResolving(grType, lastParent) && (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.CLASS))) {
            for (CandidateInfo info : CollectClassMembersUtil.getAllInnerClasses(grType, false).values()) {
                PsiClass innerClass = (PsiClass)info.getElement();
                assert (innerClass != null);
                String innerClassName = innerClass.getName();
                if (nameHint != null && !innerClassName.equals(nameHint.getName(state)) || processor.execute((PsiElement)innerClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isSuperClassReferenceResolving(GrTypeDefinition grType, PsiElement lastParent) {
        return lastParent instanceof GrReferenceList || grType.isAnonymous() && lastParent == ((GrAnonymousClassDefinition)grType).getBaseClassReferenceGroovy();
    }

    private static boolean isSameDeclaration(PsiElement place, PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        while (place != null) {
            if ((place = place.getParent()) == element) {
                return true;
            }
            if (!(place instanceof GrClosableBlock)) continue;
            return false;
        }
        return false;
    }

    private static boolean isMethodVisible(boolean isPlaceGroovy, PsiMethod method) {
        return isPlaceGroovy || !(method instanceof GrGdkMethod);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, false)) {
            MethodSignature signature;
            PsiSubstitutor superSubstitutor;
            PsiClass clazz = method.getContainingClass();
            if (clazz == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)clazz, (PsiClass)grType, (PsiSubstitutor)PsiSubstitutor.EMPTY)) == null || !(signature = method.getSignature(superSubstitutor)).equals(patternSignature)) continue;
            return method;
        }
        return null;
    }

    private static PsiMethod[] findMethodsByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSyntheticAccessors) {
        if (!checkBases) {
            ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
            for (PsiMethod psiMethod : includeSyntheticAccessors ? grType.getMethods() : grType.getGroovyMethods()) {
                if (!name.equals(psiMethod.getName())) continue;
                result.add(psiMethod);
            }
            return result.toArray(new PsiMethod[result.size()]);
        }
        Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, includeSyntheticAccessors);
        return PsiImplUtil.mapToMethods(methodsMap.get(name));
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, true);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findCodeMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, false);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.findCodeMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(grType, name, checkBases, true);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    private static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases, boolean includeSynthetic) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, includeSynthetic)) {
            MethodSignature signature;
            PsiSubstitutor superSubstitutor;
            PsiClass clazz = method.getContainingClass();
            if (clazz == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)clazz, (PsiClass)grType, (PsiSubstitutor)PsiSubstitutor.EMPTY)) == null || !(signature = method.getSignature(superSubstitutor)).equals(patternSignature)) continue;
            result.add(method);
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    @NotNull
    public static PsiMethod[] findCodeMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(grType, name, checkBases, false);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.findCodeMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(GrTypeDefinition grType, String name, boolean checkBases) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        if (!checkBases) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = grType.findMethodsByName(name, false)) {
                result.add((Pair<PsiMethod, PsiSubstitutor>)new Pair((Object)method, (Object)PsiSubstitutor.EMPTY));
            }
        } else {
            Map<String, List<CandidateInfo>> map = CollectClassMembersUtil.getAllMethods(grType, true);
            List<CandidateInfo> candidateInfos = map.get(name);
            if (candidateInfos != null) {
                for (CandidateInfo info : candidateInfos) {
                    PsiElement element = info.getElement();
                    result.add((Pair<PsiMethod, PsiSubstitutor>)new Pair((Object)((PsiMethod)element), (Object)info.getSubstitutor()));
                }
            }
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors(GrTypeDefinition grType) {
        Map<String, List<CandidateInfo>> allMethodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (List<CandidateInfo> infos : allMethodsMap.values()) {
            for (CandidateInfo info : infos) {
                result.add((Pair<PsiMethod, PsiSubstitutor>)new Pair((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
            }
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static PsiField findFieldByName(GrTypeDefinition grType, String name, boolean checkBases) {
        if (!checkBases) {
            for (GrField field : grType.getFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            return null;
        }
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
        CandidateInfo info = fieldsMap.get(name);
        return info == null ? null : (PsiField)info.getElement();
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType) {
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
        return (PsiField[])ContainerUtil.map2Array(fieldsMap.values(), PsiField.class, (Function)new Function<CandidateInfo, PsiField>(){

            public PsiField fun(CandidateInfo entry) {
                return (PsiField)entry.getElement();
            }
        });
    }

    public static boolean isClassEquivalentTo(GrTypeDefinitionImpl definition, PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo((PsiClass)definition, (PsiElement)another);
    }
}

