/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;

public class GrMapType
extends GrLiteralClassType {
    private final Map<String, PsiType> myStringEntries;
    private final List<Pair<PsiType, PsiType>> myOtherEntries;
    @NonNls
    private static final String JAVA_UTIL_LINKED_HASH_MAP = "java.util.LinkedHashMap";
    private final String myJavaClassName;

    public GrMapType(JavaPsiFacade facade, GlobalSearchScope scope, Map<String, PsiType> stringEntries, List<Pair<PsiType, PsiType>> otherEntries) {
        this(facade, scope, stringEntries, otherEntries, LanguageLevel.JDK_1_5);
    }

    public GrMapType(JavaPsiFacade facade, GlobalSearchScope scope, Map<String, PsiType> stringEntries, List<Pair<PsiType, PsiType>> otherEntries, LanguageLevel languageLevel) {
        super(languageLevel, scope, facade);
        this.myStringEntries = stringEntries;
        this.myOtherEntries = otherEntries;
        this.myJavaClassName = facade.findClass(JAVA_UTIL_LINKED_HASH_MAP, scope) != null ? JAVA_UTIL_LINKED_HASH_MAP : "java.util.Map";
    }

    @Override
    protected String getJavaClassName() {
        return this.myJavaClassName;
    }

    public String getClassName() {
        return "Map";
    }

    public PsiType[] getAllKeyTypes() {
        HashSet<Object> result = new HashSet<Object>();
        if (!this.myStringEntries.isEmpty()) {
            result.add(PsiType.getJavaLangString((PsiManager)this.getPsiManager(), (GlobalSearchScope)this.getResolveScope()));
        }
        for (Pair<PsiType, PsiType> entry : this.myOtherEntries) {
            result.add(entry.first);
        }
        result.remove(null);
        return result.toArray(new PsiType[result.size()]);
    }

    public PsiType[] getAllValueTypes() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.myStringEntries.values());
        for (Pair<PsiType, PsiType> entry : this.myOtherEntries) {
            result.add(entry.second);
        }
        result.remove(null);
        return result.toArray(new PsiType[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray;
        PsiType[] keyTypes = this.getAllKeyTypes();
        PsiType[] valueTypes = this.getAllValueTypes();
        if (keyTypes.length == 0 && valueTypes.length == 0) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrMapType.getParameters must not return null");
            return psiTypeArray;
        }
        psiTypeArray = new PsiType[]{this.getLeastUpperBound(keyTypes), this.getLeastUpperBound(valueTypes)};
        if (psiTypeArray != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrMapType.getParameters must not return null");
    }

    public String getInternalCanonicalText() {
        ArrayList<String> components = new ArrayList<String>();
        for (String string : this.myStringEntries.keySet()) {
            components.add("'" + string + "':" + GrMapType.getInternalCanonicalText(this.myStringEntries.get(string)));
        }
        for (Pair pair : this.myOtherEntries) {
            components.add(GrMapType.getInternalCanonicalText((PsiType)pair.first) + ":" + GrMapType.getInternalCanonicalText((PsiType)pair.second));
        }
        return "[" + StringUtil.join(components, (String)", ") + "]";
    }

    public boolean isValid() {
        for (PsiType psiType : this.myStringEntries.values()) {
            if (psiType == null || psiType.isValid()) continue;
            return false;
        }
        for (Pair pair : this.myOtherEntries) {
            if (pair.first != null && !((PsiType)pair.first).isValid()) {
                return false;
            }
            if (pair.second == null || ((PsiType)pair.second).isValid()) continue;
            return false;
        }
        return true;
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        return new GrMapType(this.myFacade, this.getResolveScope(), this.myStringEntries, this.myOtherEntries, languageLevel);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrMapType) {
            return ((Object)this.myStringEntries).equals(((GrMapType)((Object)obj)).myStringEntries) && ((Object)this.myOtherEntries).equals(((GrMapType)((Object)obj)).myOtherEntries);
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrMapType.isAssignableFrom must not be null");
        }
        return false;
    }
}

