/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class NonCodeMembersHolder
implements CustomMembersHolder {
    private final GrTypeDefinition myPsiClass;
    private static final Key<CachedValue<ConcurrentFactoryMap<String, NonCodeMembersHolder>>> CACHED_HOLDERS = Key.create((String)"CACHED_HOLDERS");

    public static NonCodeMembersHolder fromText(@NotNull String classText, final Project project) {
        if (classText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/holders/NonCodeMembersHolder.fromText must not be null");
        }
        return (NonCodeMembersHolder)((ConcurrentFactoryMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, CACHED_HOLDERS, (CachedValueProvider)new CachedValueProvider<ConcurrentFactoryMap<String, NonCodeMembersHolder>>(){

            public CachedValueProvider.Result<ConcurrentFactoryMap<String, NonCodeMembersHolder>> compute() {
                ConcurrentFactoryMap<String, NonCodeMembersHolder> map = new ConcurrentFactoryMap<String, NonCodeMembersHolder>(){

                    protected NonCodeMembersHolder create(String key) {
                        return new NonCodeMembersHolder(key, project);
                    }
                };
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false)).get((Object)classText);
    }

    private NonCodeMembersHolder(@NotNull String classText, Project project) {
        if (classText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/holders/NonCodeMembersHolder.<init> must not be null");
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        this.myPsiClass = factory.createGroovyFile("class GroovyEnhanced {\n" + classText + "}", false, null).getTypeDefinitions()[0];
    }

    @Override
    public boolean processMembers(PsiScopeProcessor processor) {
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String expectedName = nameHint == null ? null : nameHint.getName(ResolveState.initial());
        for (PsiMethod psiMethod : this.myPsiClass.getMethods()) {
            if (expectedName != null && !expectedName.equals(psiMethod.getName()) || processor.execute((PsiElement)psiMethod, ResolveState.initial())) continue;
            return false;
        }
        for (GrField grField : this.myPsiClass.getFields()) {
            if (expectedName != null && !expectedName.equals(grField.getName()) || processor.execute((PsiElement)grField, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }
}

