/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.SingleIntegerFieldOptionsPanel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GroovyIfStatementWithTooManyBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    @NotNull
    public String getDisplayName() {
        if ("If statement with too many branches" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithTooManyBranchesInspection.getDisplayName must not return null");
        }
        return "If statement with too many branches";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithTooManyBranchesInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    private int getLimit() {
        return this.m_limit;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel("Maximum number of branches", this, "m_limit");
    }

    @Override
    protected String buildErrorString(Object ... args) {
        GrIfStatement statement = (GrIfStatement)args[0];
        int branches = GroovyIfStatementWithTooManyBranchesInspection.calculateNumBranches(statement);
        return "'#ref' statement with too many branches (" + branches + ") #loc";
    }

    private static int calculateNumBranches(GrIfStatement statement) {
        GrStatement branch = statement.getElseBranch();
        if (branch == null) {
            return 1;
        }
        if (!(branch instanceof GrIfStatement)) {
            return 2;
        }
        return 1 + GroovyIfStatementWithTooManyBranchesInspection.calculateNumBranches((GrIfStatement)branch);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            GrIfStatement parentStatement;
            GrStatement elseBranch;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithTooManyBranchesInspection$Visitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof GrIfStatement && statement.equals(elseBranch = (parentStatement = (GrIfStatement)parent).getElseBranch())) {
                return;
            }
            int branches = GroovyIfStatementWithTooManyBranchesInspection.calculateNumBranches(statement);
            if (branches <= GroovyIfStatementWithTooManyBranchesInspection.this.getLimit()) {
                return;
            }
            this.registerStatementError(statement, statement);
        }
    }
}

