/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.execution.RunManagerEx;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.actions.MavenExecuteBeforeRunDialog;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;
import org.jetbrains.idea.maven.utils.actions.MavenToggleAction;

public class ToggleBeforeRunTaskAction
extends MavenToggleAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && this.getTaskDesc(e) != null;
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        Pair<MavenProject, String> desc = this.getTaskDesc(e);
        for (MavenBeforeRunTask each : this.getRunManager(e).getBeforeRunTasks(MavenBeforeRunTasksProvider.TASK_ID, true)) {
            if (!each.isEnabled() || !each.isFor((MavenProject)desc.first, (String)desc.second)) continue;
            return true;
        }
        return false;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Pair<MavenProject, String> desc = this.getTaskDesc(e);
        new MavenExecuteBeforeRunDialog(MavenActionUtil.getProject(e), (MavenProject)desc.first, (String)desc.second).show();
    }

    protected Pair<MavenProject, String> getTaskDesc(AnActionEvent e) {
        MavenProject mavenProject = MavenActionUtil.getMavenProject(e);
        if (mavenProject == null) {
            return null;
        }
        List goals = (List)e.getData(MavenDataKeys.MAVEN_GOALS);
        if (goals == null || goals.size() != 1) {
            return null;
        }
        return Pair.create((Object)mavenProject, goals.get(0));
    }

    private RunManagerEx getRunManager(AnActionEvent e) {
        return RunManagerEx.getInstanceEx((Project)MavenActionUtil.getProject(e));
    }
}

