/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class AddMavenDependencyQuickFix
implements IntentionAction {
    private final PsiJavaCodeReferenceElement myRef;

    public AddMavenDependencyQuickFix(PsiJavaCodeReferenceElement ref) {
        this.myRef = ref;
    }

    @NotNull
    public String getText() {
        if ("Add Maven Dependency..." == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix.getText must not return null");
        }
        return "Add Maven Dependency...";
    }

    @NotNull
    public String getFamilyName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix.isAvailable must not be null");
        }
        return MavenDomUtil.findContainingMavenizedModule(file) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix.invoke must not be null");
        }
        MavenId dependency = MavenArtifactSearchDialog.searchForClass(project, this.getReferenceText());
        if (dependency == null) {
            return;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(MavenDomUtil.findContainingMavenizedModule(file));
        MavenProjectsManager.getInstance(project).addDependency(mavenProject, dependency);
    }

    private String getReferenceText() {
        PsiJavaCodeReferenceElement result = this.myRef;
        while (result.getParent() instanceof PsiJavaCodeReferenceElement) {
            result = result.getParent();
        }
        return result.getText();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

