/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.ClassUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.ListTableModel;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestNGConsoleProperties;
import com.theoryinpractice.testng.model.TestNGResultsTableModel;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.model.TestTreeBuilder;
import com.theoryinpractice.testng.model.TestTreeStructure;
import com.theoryinpractice.testng.model.TreeRootNode;
import com.theoryinpractice.testng.ui.Animator;
import com.theoryinpractice.testng.ui.Printable;
import com.theoryinpractice.testng.ui.TestNGConsoleView;
import com.theoryinpractice.testng.ui.TestNGTestTreeView;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGResults
extends TestResultsPanel
implements TestFrameworkRunningModel {
    @NonNls
    private static final String TESTNG_SPLITTER_PROPERTY = "TestNG.Splitter.Proportion";
    private final TableView resultsTable;
    private final TestNGResultsTableModel model;
    private TestNGTestTreeView tree;
    private final Project project;
    private int count;
    private int total;
    private final Set<TestProxy> failed = new HashSet<TestProxy>();
    private final Map<TestResultMessage, TestProxy> started = new HashMap<TestResultMessage, TestProxy>();
    private TestProxy failedToStart = null;
    private long start;
    private long end;
    private TestTreeBuilder treeBuilder;
    private Animator animator;
    private final Pattern packagePattern = Pattern.compile("(.*)\\.(.*)");
    private final TreeRootNode rootNode;
    private static final String NO_PACKAGE = "No Package";
    private OpenSourceSelectionListener openSourceListener;
    private final TestNGConsoleView myConsole;
    private int myStatus = 1001;

    public TestNGResults(JComponent component, TestNGConfiguration configuration, TestNGConsoleView console, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        super(component, console.createConsoleActions(), console.getProperties(), runnerSettings, configurationSettings, TESTNG_SPLITTER_PROPERTY, 0.5f);
        this.myConsole = console;
        this.project = configuration.getProject();
        this.model = new TestNGResultsTableModel();
        this.resultsTable = new TableView((ListTableModel)this.model);
        this.resultsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object result;
                if (e.getClickCount() == 2 && (result = TestNGResults.this.resultsTable.getSelectedObject()) instanceof TestResultMessage) {
                    String testClass = ((TestResultMessage)result).getTestClass();
                    PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)TestNGResults.this.project), (String)testClass);
                    if (psiClass != null) {
                        PsiMethod[] psiMethods;
                        PsiMethod[] arr$;
                        int len$;
                        int i$;
                        String method = ((TestResultMessage)result).getMethod();
                        if (method != null && (i$ = 0) < (len$ = (arr$ = (psiMethods = psiClass.findMethodsByName(method, false))).length)) {
                            PsiMethod psiMethod = arr$[i$];
                            psiMethod.navigate(true);
                            return;
                        }
                        psiClass.navigate(true);
                    }
                }
            }
        });
        this.rootNode = new TreeRootNode();
    }

    protected JComponent createTestTreeView() {
        this.tree = new TestNGTestTreeView();
        TestTreeStructure structure = new TestTreeStructure(this.project, this.rootNode);
        this.tree.attachToModel(this);
        this.treeBuilder = new TestTreeBuilder((JTree)((Object)this.tree), structure);
        Disposer.register((Disposable)this, (Disposable)this.treeBuilder);
        this.animator = new Animator((Disposable)this, this.treeBuilder);
        this.openSourceListener = new OpenSourceSelectionListener(structure, this.myConsole);
        this.tree.getSelectionModel().addTreeSelectionListener(this.openSourceListener);
        return this.tree;
    }

    protected ToolbarPanel createToolbarPanel() {
        ToolbarPanel panel = new ToolbarPanel(this.getProperties(), this.myRunnerSettings, this.myConfigurationSettings, (JComponent)((Object)this));
        panel.setModel((TestFrameworkRunningModel)this);
        return panel;
    }

    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    protected JComponent createStatisticsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.resultsTable, "Center");
        return panel;
    }

    private void updateStatusLine() {
        this.myStatusLine.setText(this.getStatusLine());
    }

    public int getStatus() {
        return this.myStatus;
    }

    public String getStatusLine() {
        StringBuffer sb = new StringBuffer();
        if (this.end == 0L) {
            sb.append("Running: ");
        } else {
            sb.append("Done: ");
        }
        sb.append(this.count).append(" of ").append(this.total);
        if (this.failed.size() > 0) {
            sb.append("   Failed: ").append(this.failed.size()).append(' ');
        }
        if (this.end != 0L) {
            long time = this.end - this.start;
            sb.append(" (").append(time == 0L ? "0.0 s" : NumberFormat.getInstance().format((double)time / 1000.0) + " s").append(")  ");
        }
        return sb.toString();
    }

    public TestProxy testStarted(TestResultMessage result) {
        boolean flattenPackages = true;
        TestProxy classNode = flattenPackages ? this.getPackageClassNodeFor(result) : this.getClassNodeFor(result);
        TestProxy proxy = new TestProxy();
        proxy.setParent(classNode);
        proxy.setResultMessage(result);
        this.started.put(result, proxy);
        this.animator.setCurrentTestCase(proxy);
        this.treeBuilder.addItem(classNode, proxy);
        this.treeBuilder.repaintWithParents(proxy);
        ++this.count;
        if (this.count > this.total) {
            this.total = this.count;
        }
        if (TestNGConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.selectTest(proxy);
        }
        return proxy;
    }

    public boolean wasTestStarted(TestResultMessage resultMessage) {
        return this.started.get(resultMessage) != null;
    }

    public void addTestResult(final TestResultMessage result, List<Printable> output, int exceptionMark) {
        PsiMethod[] methods;
        PsiElement element;
        TestProxy testCase;
        if (this.failedToStart != null) {
            output.addAll(this.failedToStart.getOutput());
            exceptionMark += this.failedToStart.getExceptionMark();
        }
        if ((testCase = this.started.get(result)) == null && (element = this.getPackageClassNodeFor(result).getPsiElement()) instanceof PsiClass && (methods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return ((PsiClass)element).findMethodsByName(result.getMethod(), true);
            }
        })).length > 0 && !AnnotationUtil.isAnnotated((PsiModifierListOwner)methods[0], Arrays.asList(TestNGUtil.CONFIG_ANNOTATIONS_FQN))) {
            testCase = this.testStarted(result);
        }
        if (testCase != null) {
            testCase.setResultMessage(result);
            this.failedToStart = null;
            if (result.getResult() == 1002) {
                this.failed.add(testCase);
            }
            this.model.addTestResult(result);
        } else {
            this.failedToStart = testCase = new TestProxy();
        }
        testCase.setOutput(output);
        testCase.setExceptionMark(exceptionMark);
        if (result.getResult() == 1002) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
            this.myStatus = 1002;
        } else if (result.getResult() == 1003 && this.myStatus == 1001) {
            this.myStatus = 1003;
        }
        this.myStatusLine.setFraction((double)this.count / (double)this.total);
        this.updateStatusLine();
    }

    private String packageNameFor(String fqnClassName) {
        Matcher matcher = this.packagePattern.matcher(fqnClassName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return NO_PACKAGE;
    }

    private String classNameFor(String fqnClassName) {
        Matcher matcher = this.packagePattern.matcher(fqnClassName);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return fqnClassName;
    }

    private TestProxy getPackageClassNodeFor(final TestResultMessage result) {
        TestProxy owner = this.treeBuilder.getRoot();
        String packageName = this.packageNameFor(result.getTestClass());
        if ((owner = this.getChildNodeNamed(owner, packageName)).getPsiElement() == null) {
            owner.setPsiElement((PsiElement)JavaPsiFacade.getInstance((Project)this.project).findPackage(packageName));
        }
        if ((owner = this.getChildNodeNamed(owner, this.classNameFor(result.getTestClass()))).getPsiElement() == null) {
            final TestProxy finalOwner = owner;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    finalOwner.setPsiElement((PsiElement)ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)TestNGResults.this.project), (String)result.getTestClass()));
                }
            });
        }
        return owner;
    }

    private TestProxy getClassNodeFor(TestResultMessage result) {
        String[] nodes = result.getTestClass().split("\\.");
        TestProxy owner = this.treeBuilder.getRoot();
        for (String node : nodes) {
            owner = this.getChildNodeNamed(owner, node);
        }
        return owner;
    }

    private TestProxy getChildNodeNamed(TestProxy currentNode, String node) {
        for (TestProxy child : currentNode.getChildren()) {
            if (!child.getName().equals(node)) continue;
            return child;
        }
        TestProxy child = new TestProxy(node);
        this.treeBuilder.addItem(currentNode, child);
        return child;
    }

    public void selectTest(TestProxy proxy) {
        if (proxy == null) {
            return;
        }
        this.treeBuilder.select(proxy, null);
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void start() {
        this.start = System.currentTimeMillis();
        this.tree.getSelectionModel().setSelectionPath(new TreePath(this.treeBuilder.getNodeForElement(this.rootNode)));
        this.rootNode.setInProgress(true);
        this.rootNode.setStarted(true);
    }

    public void finish() {
        if (this.end > 0L) {
            return;
        }
        this.end = System.currentTimeMillis();
        LvcsHelper.addLabel((TestFrameworkRunningModel)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestNGResults.this.animator.stopMovie();
                TestNGResults.this.updateStatusLine();
                if (TestNGResults.this.total > TestNGResults.this.count) {
                    TestNGResults.this.myStatusLine.setStatusColor(ColorProgressBar.YELLOW);
                }
                TestNGResults.this.rootNode.setInProgress(false);
                if (TestNGConsoleProperties.SELECT_FIRST_DEFECT.value((AbstractProperty.AbstractPropertyContainer)TestNGResults.this.myProperties)) {
                    TestNGResults.this.selectTest(TestNGResults.this.rootNode.getFirstDefect());
                } else {
                    DefaultMutableTreeNode node = TestNGResults.this.treeBuilder.getNodeForElement(TestNGResults.this.rootNode);
                    if (node != null) {
                        TestNGResults.this.tree.getSelectionModel().setSelectionPath(new TreePath(node));
                    }
                }
                TestNGResults.this.tree.repaint();
            }
        });
    }

    public void setFilter(Filter filter) {
        this.getTreeStructure().setFilter(filter);
        this.treeBuilder.updateFromRoot();
    }

    public boolean isRunning() {
        return this.rootNode.isInProgress();
    }

    public TestTreeView getTreeView() {
        return this.tree;
    }

    public boolean hasTestSuites() {
        return this.rootNode.getChildren().size() > 0;
    }

    public TestProxy getRoot() {
        return this.rootNode;
    }

    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectTest((TestProxy)testProxy);
    }

    public TestTreeStructure getTreeStructure() {
        return (TestTreeStructure)this.treeBuilder.getTreeStructure();
    }

    public void rebuildTree() {
        this.treeBuilder.updateFromRoot();
        this.tree.invalidate();
    }

    public void dispose() {
        super.dispose();
        this.openSourceListener.structure = null;
        this.openSourceListener.console = null;
        this.tree.getSelectionModel().removeTreeSelectionListener(this.openSourceListener);
    }

    public TestProxy getFailedToStart() {
        return this.failedToStart;
    }

    private class OpenSourceSelectionListener
    implements TreeSelectionListener {
        private TestTreeStructure structure;
        private TestNGConsoleView console;

        public OpenSourceSelectionListener(TestTreeStructure structure, TestNGConsoleView console) {
            this.structure = structure;
            this.console = console;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getPath();
            if (path == null) {
                return;
            }
            TestProxy proxy = (TestProxy)TestNGResults.this.tree.getSelectedTest();
            if (proxy == null) {
                return;
            }
            if (ScrollToTestSourceAction.isScrollEnabled((TestFrameworkRunningModel)TestNGResults.this)) {
                OpenSourceUtil.openSourcesFrom((DataProvider)TestNGResults.this.tree, (boolean)false);
            }
            if (proxy == this.structure.getRootElement()) {
                this.console.reset();
            } else {
                this.console.setView(proxy.getOutput(), TestNGConsoleProperties.SCROLL_TO_STACK_TRACE.value((AbstractProperty.AbstractPropertyContainer)TestNGResults.this.getProperties()) ? proxy.getExceptionMark() : 0);
            }
        }
    }
}

