/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.parenthesis;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.parenthesis.AddClarifyingParenthesesPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddClarifyingParenthesesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AddClarifyingParenthesesPredicate addClarifyingParenthesesPredicate = new AddClarifyingParenthesesPredicate();
        if (addClarifyingParenthesesPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/parenthesis/AddClarifyingParenthesesIntention.getElementPredicate must not return null");
        }
        return addClarifyingParenthesesPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/parenthesis/AddClarifyingParenthesesIntention.processIntention must not be null");
        }
        PsiExpression expression = AddClarifyingParenthesesIntention.getTopLevelExpression(element);
        if (expression == null) {
            return;
        }
        StringBuilder newExpression = AddClarifyingParenthesesIntention.createReplacementText(expression, new StringBuilder());
        AddClarifyingParenthesesIntention.replaceExpression(newExpression.toString(), expression);
    }

    @Nullable
    private static PsiExpression getTopLevelExpression(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        PsiExpression result = (PsiExpression)element;
        PsiElement parent = result.getParent();
        while (parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression) {
            result = (PsiExpression)parent;
            parent = result.getParent();
        }
        return result;
    }

    private static StringBuilder createReplacementText(PsiExpression element, StringBuilder out) {
        if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression parentBinaryExpression;
            PsiJavaToken parentOperationSign;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiJavaToken operationSign = binaryExpression.getOperationSign();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiElement parent = element.getParent();
            String signText = operationSign.getText();
            PsiElement lhsNextSibling = lhs.getNextSibling();
            PsiElement rhsPrevSibling = rhs != null ? rhs.getPrevSibling() : null;
            if (parent instanceof PsiBinaryExpression && !signText.equals((parentOperationSign = (parentBinaryExpression = (PsiBinaryExpression)parent).getOperationSign()).getText())) {
                out.append('(');
                AddClarifyingParenthesesIntention.createReplacementText(lhs, out);
                if (lhsNextSibling instanceof PsiWhiteSpace) {
                    out.append(lhsNextSibling.getText());
                }
                out.append(signText);
                if (rhsPrevSibling instanceof PsiWhiteSpace) {
                    out.append(rhsPrevSibling.getText());
                }
                AddClarifyingParenthesesIntention.createReplacementText(rhs, out);
                out.append(')');
                return out;
            }
            AddClarifyingParenthesesIntention.createReplacementText(lhs, out);
            if (lhsNextSibling instanceof PsiWhiteSpace) {
                out.append(lhsNextSibling.getText());
            }
            out.append(signText);
            if (rhsPrevSibling instanceof PsiWhiteSpace) {
                out.append(rhsPrevSibling.getText());
            }
            AddClarifyingParenthesesIntention.createReplacementText(rhs, out);
        } else if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            PsiExpression expression = parenthesizedExpression.getExpression();
            out.append('(');
            AddClarifyingParenthesesIntention.createReplacementText(expression, out);
            out.append(')');
        } else if (element instanceof PsiInstanceOfExpression) {
            out.append('(');
            out.append(element.getText());
            out.append(')');
        } else if (element != null) {
            out.append(element.getText());
        }
        return out;
    }
}

